/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.treeview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.desktop.components.treeview.TdkCellRenderingParams;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.util.TdkTreeDnDRenderer;
import org.tecgraf.jtdk.desktop.components.util.TristateCheckBox;

public class TdkTreeViewRenderer
extends JPanel
implements TreeCellRenderer,
TdkTreeDnDRenderer {
    private static Logger _logger = Logger.getLogger(TdkTreeViewRenderer.class);
    private boolean _selected;
    private boolean _drawsFocusBorderAroundIcon;
    private boolean _hasFocus;
    private TdkCellRenderingParams _params;
    private TristateCheckBox _checkbox = new TristateCheckBox();
    private JLabel _label = new MyJLabel();

    public TdkTreeViewRenderer() {
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this._drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this._hasFocus = bl4;
        this._selected = bl;
        if (object != null && object instanceof TdkLegendElement) {
            TdkLegendElement tdkLegendElement = (TdkLegendElement)object;
            this._params = tdkLegendElement.getRenderParams();
            this.removeAll();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(1, 2, 1, 1);
            if (this._params.getCheckboxGrayBackground()) {
                this._checkbox.setEnabled(false);
            } else {
                this._checkbox.setEnabled(true);
            }
            this._checkbox.setSelected(tdkLegendElement.isChecked());
            this._label.setFont(this._params.getTextStyle());
            this._label.setText(this._params.getCaption());
            Color color = null;
            color = bl ? this._params.getSelectionForeground() : this._params.getTextColor();
            if (color != null) {
                this._label.setForeground(color);
            }
            this.setBackground(jTree.getBackground());
            this._checkbox.setBackground(jTree.getBackground());
            if (bl2) {
                if (this._params.getOpenIcon() != null) {
                    this._label.setIcon(this._params.getOpenIcon());
                }
            } else if (this._params.getIcon() != null) {
                this._label.setIcon(this._params.getIcon());
            }
            this._label.setBorder(new EmptyBorder(0, this._params.getSpaceBefore(), 0, 2));
            if (!this._params.hasCheckbox()) {
                this.add((Component)this._label, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                JPanel jPanel = new JPanel();
                jPanel.setOpaque(false);
                this.add((Component)jPanel, gridBagConstraints);
            } else {
                this.add((Component)this._checkbox, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                this.add((Component)this._label, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 1.0;
                JPanel jPanel = new JPanel();
                jPanel.setOpaque(false);
                this.add((Component)jPanel, gridBagConstraints);
            }
        }
        if (this._params == null) {
            this._params = new TdkCellRenderingParams();
        }
        return this;
    }

    @Override
    public JLabel getLabel() {
        return this._label;
    }

    private class MyJLabel
    extends JLabel {
        private MyJLabel() {
        }

        @Override
        public void paint(Graphics graphics) {
            Object object;
            Color color;
            if (TdkTreeViewRenderer.this._selected) {
                color = TdkTreeViewRenderer.this._params.getSelectionBackground();
            } else {
                color = TdkTreeViewRenderer.this._params.getNonSelectionBackground();
                if (color == null) {
                    color = this.getBackground();
                }
            }
            int n = -1;
            if (color != null) {
                object = this.getIcon();
                n = this.getLabelStart();
                graphics.setColor(color);
                if (this.getComponentOrientation().isLeftToRight()) {
                    graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
                } else {
                    graphics.fillRect(0, 0, this.getWidth() - 1 - n, this.getHeight());
                }
            }
            if (TdkTreeViewRenderer.this._hasFocus) {
                if (TdkTreeViewRenderer.this._drawsFocusBorderAroundIcon) {
                    n = 0;
                } else if (n == -1) {
                    n = this.getLabelStart();
                }
                object = TdkTreeViewRenderer.this._params.getSelectionBorder();
                if (object != null) {
                    graphics.setColor((Color)object);
                    if (this.getComponentOrientation().isLeftToRight()) {
                        graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
                    } else {
                        graphics.drawRect(0, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
                    }
                }
            }
            super.paint(graphics);
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        private int getLabelStart() {
            Icon icon = this.getIcon();
            if (icon != null && this.getText() != null) {
                return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1) - 2;
            }
            return 0;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension != null) {
                dimension = new Dimension(dimension.width + 3, dimension.height);
            }
            return dimension;
        }
    }
}

