/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.treeview;

import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkThemeGroupGID;
import org.tecgraf.jtdk.core.swig.TdkView;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGIDVector;
import org.tecgraf.jtdk.desktop.components.TdkComponentsI18n;
import org.tecgraf.jtdk.desktop.components.treeview.TdkCellRenderingParams;
import org.tecgraf.jtdk.desktop.components.treeview.TdkDummyLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElementFactory;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeView;
import org.tecgraf.jtdk.desktop.components.treeview.TdkUpdateViewEvent;

public class TdkViewLegendElement
extends TdkLegendElement {
    private static Logger _logger = Logger.getLogger(TdkViewLegendElement.class);
    protected TdkViewGID _gid;
    TdkViewNodeGIDVector _viewNodeGIDs;
    Action a1;
    boolean _isProjEditable = false;

    public TdkViewLegendElement(TdkTreeView tdkTreeView, TdkViewGID tdkViewGID) {
        this(tdkTreeView, true, true, tdkViewGID);
    }

    public TdkViewLegendElement(TdkTreeView tdkTreeView, boolean bl, boolean bl2, TdkViewGID tdkViewGID) {
        super(tdkTreeView, bl, bl2);
        this._gid = tdkViewGID;
        TdkView tdkView = TdkSetup.getPersistenceService().getView(tdkViewGID);
        TdkCellRenderingParams tdkCellRenderingParams = new TdkCellRenderingParams();
        tdkCellRenderingParams.setCaption(tdkView.getName());
        tdkCellRenderingParams.setHasCheckbox(false);
        tdkCellRenderingParams.setIcon(new ImageIcon(this.getClass().getResource("/org/tecgraf/jtdk/desktop/components/icons/view.png")));
        this.setRenderParams(tdkCellRenderingParams);
        this._viewNodeGIDs = tdkView.getViewNodeIdVector();
        this.setAllowsChildren(true);
        this.add(new TdkDummyLegendElement());
        this.buildPopupMenu();
    }

    public void setProjectionEditable(boolean bl) {
        this._isProjEditable = bl;
    }

    public boolean isProjectionEditable() {
        return this._isProjEditable;
    }

    public TdkViewGID getGID() {
        return this._gid;
    }

    @Override
    public Object getUserObject() {
        return this.getRenderParams().getCaption();
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof String) {
            TdkUpdateViewEvent tdkUpdateViewEvent = new TdkUpdateViewEvent();
            tdkUpdateViewEvent.setNameChanged(true);
            this._treeView.fireViewChangeEvent(true, this, tdkUpdateViewEvent);
            this.getRenderParams().setCaption((String)object);
            TdkView tdkView = TdkSetup.getPersistenceService().getView(this._gid);
            this._treeView.fireViewChangeEvent(false, this, tdkUpdateViewEvent);
            this._treeView.repaint();
        }
    }

    public TdkViewNodeGIDVector getChildrenIds() {
        return this._viewNodeGIDs;
    }

    @Override
    public Vector<TdkLegendElement> makeChildren() {
        TdkLegendElementFactory tdkLegendElementFactory = this._treeView.getFactory();
        if (tdkLegendElementFactory == null) {
            return null;
        }
        boolean bl = this._treeView.isNodesEditable();
        boolean bl2 = this._treeView.isRemovable();
        Vector<TdkLegendElement> vector = new Vector<TdkLegendElement>();
        TdkView tdkView = TdkSetup.getPersistenceService().getView(this._gid);
        this._viewNodeGIDs = tdkView.getViewNodeIdVector();
        int n = 0;
        while ((long)n < this._viewNodeGIDs.size()) {
            TdkThemeGID tdkThemeGID;
            TdkViewNodeGID tdkViewNodeGID = this._viewNodeGIDs.get(n);
            if (tdkViewNodeGID instanceof TdkThemeGID) {
                tdkThemeGID = (TdkThemeGID)tdkViewNodeGID;
                vector.add(tdkLegendElementFactory.makeThemeElement(this._treeView, bl, bl2, tdkThemeGID));
            } else if (tdkViewNodeGID instanceof TdkThemeGroupGID) {
                tdkThemeGID = (TdkThemeGroupGID)tdkViewNodeGID;
                vector.add(tdkLegendElementFactory.makeThemeGroupElement(this._treeView, bl, bl2, (TdkThemeGroupGID)tdkThemeGID));
            }
            ++n;
        }
        return vector;
    }

    public void buildPopupMenu() {
        if (this.isEditable()) {
            this.getPopupMenu().addSeparator();
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_NEW_GROUP"), "new_group_command");
            if (this._isProjEditable) {
                this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_VIEW_PROJ_EDIT"), "view_proj_edit_command");
            } else {
                this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_VIEW_SHOW_PROJ"), "show_proj_command");
            }
            this.getPopupMenu().addSeparator();
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_VIEW_SAVE"), "view_save_command");
        } else {
            this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_VIEW_SHOW_PROJ"), "show_proj_command");
        }
        this.getPopupMenu().addSeparator();
        this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_VIEW_SHOW_ALL"), "view_show_all_command");
        this.addMenuItem(TdkComponentsI18n.getString("TREE_POP_MENU_VIEW_HIDE_ALL"), "view_hide_all_command");
        this.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    @Override
    public boolean equals(Object object) {
        if (this._gid == null) {
            return super.equals(object);
        }
        if (!(object instanceof TdkViewLegendElement)) {
            return false;
        }
        TdkViewGID tdkViewGID = ((TdkViewLegendElement)object).getGID();
        if (this._gid.getDBKey() == null) {
            return this._gid.getId() == tdkViewGID.getId();
        }
        return this._gid.getId() == tdkViewGID.getId() && this._gid.getDBKey().equals(tdkViewGID.getDBKey());
    }

    @Override
    public int hashCode() {
        if (this._gid == null) {
            return super.hashCode();
        }
        if (this._gid.getDBKey() == null) {
            return this._gid.getIdStr().hashCode();
        }
        String string = this._gid.getIdStr() + this._gid.getDBKey();
        return string.hashCode();
    }
}

