/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.util;

import java.awt.Color;
import java.util.Vector;

public class TdkColorRamp {
    protected Vector<Double> stripes_ = new Vector();
    protected Vector<Color> colors_ = new Vector();
    protected Color defaultColor_ = Color.BLACK;

    public TdkColorRamp() {
    }

    public TdkColorRamp(double d, Color color, double d2, Color color2) {
        this.addStripe(d, color);
        this.addStripe(d2, color2);
    }

    public Color getColor(double d) {
        int n = this.stripes_.size();
        if (n < 2) {
            if (n == 1) {
                return this.colors_.elementAt(0);
            }
            return this.defaultColor_;
        }
        if (d < this.stripes_.elementAt(0)) {
            return this.colors_.elementAt(0);
        }
        if (d > this.stripes_.elementAt(n - 1)) {
            return this.colors_.elementAt(n - 1);
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 1; i < n; ++i) {
            if (!(d < this.stripes_.elementAt(i))) continue;
            n2 = i - 1;
            n3 = i;
            break;
        }
        if (n3 == 0) {
            n2 = n - 2;
            n3 = n - 1;
        }
        return this.interpolateColors(n2, n3, d);
    }

    public Color getColor(int n) {
        return this.getColor((double)n);
    }

    public void addStripe(double d, Color color) {
        int n = 0;
        int n2 = this.stripes_.size();
        if (color == null) {
            color = this.defaultColor_;
        }
        for (int i = 0; i < n2; ++i) {
            if (d < this.stripes_.elementAt(i)) {
                n = i;
                break;
            }
            if (i != n2 - 1) continue;
            n = n2;
        }
        this.stripes_.add(n, d);
        this.colors_.add(n, color);
    }

    public void removeStripe(int n) {
        int n2 = this.stripes_.size();
        if (n < 0) {
            return;
        }
        if (n >= n2) {
            return;
        }
        this.stripes_.remove(n);
        this.colors_.remove(n);
    }

    protected Color interpolateColors(int n, int n2, double d) {
        Color color = this.colors_.elementAt(n);
        Color color2 = this.colors_.elementAt(n2);
        double d2 = this.stripes_.elementAt(n);
        double d3 = this.stripes_.elementAt(n2);
        double d4 = (d - d2) / (d3 - d2);
        int n3 = (int)((double)color2.getRed() * d4 + (double)color.getRed() * (1.0 - d4));
        int n4 = (int)((double)color2.getGreen() * d4 + (double)color.getGreen() * (1.0 - d4));
        int n5 = (int)((double)color2.getBlue() * d4 + (double)color.getBlue() * (1.0 - d4));
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > 255) {
            n5 = 255;
        }
        return new Color(n3, n4, n5);
    }

    protected void printStripes() {
        System.out.println();
        for (int i = 0; i < this.stripes_.size(); ++i) {
            System.out.println("Stripe: " + i + "  Valor: " + this.stripes_.elementAt(i) + "  Cor: " + this.colors_.elementAt(i));
        }
    }
}

