/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.util;

import java.awt.Color;
import java.util.Iterator;
import java.util.Vector;
import org.tecgraf.jtdk.desktop.components.util.TdkColorDefaultPallete;
import org.tecgraf.jtdk.desktop.components.util.TdkColorRamp;

public class TdkColorScheme {
    Vector<Color> _sourceColors;

    public TdkColorScheme(Color[] colorArray) {
        this._sourceColors = new Vector();
        for (Color color : colorArray) {
            this._sourceColors.add(color);
        }
    }

    public TdkColorScheme(Vector<Color> vector) {
        this._sourceColors = vector;
    }

    public TdkColorScheme(TdkColorDefaultPallete tdkColorDefaultPallete) {
        this._sourceColors = new Vector();
        switch (tdkColorDefaultPallete) {
            case TdkRedBlueYellowGreen: {
                this._sourceColors.add(new Color(255, 0, 0));
                this._sourceColors.add(new Color(0, 0, 255));
                this._sourceColors.add(new Color(255, 255, 0));
                this._sourceColors.add(new Color(0, 255, 0));
                break;
            }
            case TdkLandCover: {
                this._sourceColors.add(new Color(0, 100, 0));
                this._sourceColors.add(new Color(90, 240, 60));
                this._sourceColors.add(new Color(240, 240, 80));
                this._sourceColors.add(new Color(200, 10, 30));
                break;
            }
            case TdkColdTemperatures: {
                this._sourceColors.add(new Color(250, 0, 250));
                this._sourceColors.add(new Color(0, 0, 250));
                this._sourceColors.add(new Color(0, 250, 250));
                this._sourceColors.add(new Color(0, 250, 0));
                break;
            }
            case TdkHotTemperatures: {
                this._sourceColors.add(new Color(0, 250, 0));
                this._sourceColors.add(new Color(250, 250, 0));
                this._sourceColors.add(new Color(250, 0, 0));
                this._sourceColors.add(new Color(250, 0, 250));
                break;
            }
            case TdkSeaFloorElevation: {
                this._sourceColors.add(new Color(0, 0, 0));
                this._sourceColors.add(new Color(0, 0, 250));
                this._sourceColors.add(new Color(0, 250, 250));
                this._sourceColors.add(new Color(0, 250, 0));
                break;
            }
            case TdkMinerals: {
                this._sourceColors.add(new Color(100, 250, 245));
                this._sourceColors.add(new Color(110, 55, 175));
                this._sourceColors.add(new Color(255, 130, 115));
                this._sourceColors.add(new Color(0, 255, 165));
                break;
            }
            case TdkFruitsVegetables: {
                this._sourceColors.add(new Color(30, 180, 30));
                this._sourceColors.add(new Color(200, 255, 20));
                this._sourceColors.add(new Color(255, 215, 20));
                this._sourceColors.add(new Color(250, 35, 30));
                break;
            }
            case TdkPastels: {
                this._sourceColors.add(new Color(230, 170, 240));
                this._sourceColors.add(new Color(155, 255, 220));
                this._sourceColors.add(new Color(245, 245, 150));
                this._sourceColors.add(new Color(250, 160, 160));
                break;
            }
            case TdkRainForest: {
                this._sourceColors.add(new Color(45, 90, 40));
                this._sourceColors.add(new Color(45, 255, 40));
                this._sourceColors.add(new Color(200, 255, 50));
                this._sourceColors.add(new Color(150, 125, 50));
                break;
            }
            case TdkAutumnLeaves: {
                this._sourceColors.add(new Color(100, 85, 45));
                this._sourceColors.add(new Color(230, 190, 80));
                this._sourceColors.add(new Color(250, 60, 60));
                this._sourceColors.add(new Color(255, 250, 75));
                break;
            }
            case TdkDarkTones: {
                this._sourceColors.add(new Color(60, 60, 130));
                this._sourceColors.add(new Color(145, 30, 30));
                this._sourceColors.add(new Color(30, 130, 30));
                this._sourceColors.add(new Color(140, 140, 30));
                break;
            }
            default: {
                this._sourceColors.add(new Color(0, 255, 255));
                this._sourceColors.add(new Color(255, 250, 0));
                this._sourceColors.add(new Color(255, 0, 250));
                this._sourceColors.add(new Color(0, 0, 0));
            }
        }
    }

    public Color[] getSourceColors() {
        Color[] colorArray = new Color[this._sourceColors.size()];
        int n = 0;
        Iterator<Color> iterator = this._sourceColors.iterator();
        while (iterator.hasNext()) {
            Color color;
            colorArray[n] = color = iterator.next();
            ++n;
        }
        return colorArray;
    }

    public TdkColorRamp generateRamp() {
        TdkColorRamp tdkColorRamp = new TdkColorRamp();
        double d = 0.0;
        for (int i = 0; i < this._sourceColors.size(); ++i) {
            tdkColorRamp.addStripe(d, this._sourceColors.get(i));
            d += 1.0 / (double)this._sourceColors.size();
        }
        return tdkColorRamp;
    }

    public Color[] generateSchemeColors(int n) {
        TdkColorRamp tdkColorRamp = this.generateRamp();
        Color[] colorArray = new Color[n];
        double d = 1.0 / (double)n;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            colorArray[i] = tdkColorRamp.getColor(d2);
            d2 += d;
        }
        return colorArray;
    }
}

