/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkThemeGroupLegendElement;
import org.tecgraf.jtdk.desktop.components.treeview.TdkViewLegendElement;
import org.tecgraf.jtdk.desktop.components.util.TdkTransferableTreePath;
import org.tecgraf.jtdk.desktop.components.util.TdkTreeDnDRenderer;

public abstract class TdkDnDTree
extends JTree
implements DragSourceListener,
DragGestureListener,
Autoscroll {
    private static final long serialVersionUID = 2728322916941693992L;
    private TreePath _pathSource;
    private BufferedImage _imgGhost;
    private Point _ptOffset = new Point();
    private DragGestureRecognizer dragGestureRecognizer;
    private static final int AUTOSCROLL_MARGIN = 12;

    public TdkDnDTree() {
        this.putClientProperty("JTree.lineStyle", "Angled");
        DragSource dragSource = DragSource.getDefaultDragSource();
        this.dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        DropTarget dropTarget = new DropTarget(this, new CDropTargetListener());
        dropTarget.setDefaultActions(2);
    }

    public abstract boolean canDrag(TreePath var1);

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getComponent() != this ? SwingUtilities.convertPoint(dragGestureEvent.getComponent(), dragGestureEvent.getDragOrigin().x, dragGestureEvent.getDragOrigin().y, this) : dragGestureEvent.getDragOrigin();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        if (this.isRootPath(treePath)) {
            return;
        }
        if (!this.canDrag(treePath)) {
            return;
        }
        Rectangle rectangle = this.getPathBounds(treePath);
        this._ptOffset.setLocation(point.x - rectangle.x, point.y - rectangle.y);
        JLabel jLabel = ((TdkTreeDnDRenderer)((Object)this.getCellRenderer().getTreeCellRendererComponent(this, treePath.getLastPathComponent(), false, this.isExpanded(treePath), this.getModel().isLeaf(treePath.getLastPathComponent()), 0, false))).getLabel();
        jLabel.setSize((int)rectangle.getWidth(), (int)rectangle.getHeight());
        this._imgGhost = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 3);
        Graphics2D graphics2D = this._imgGhost.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
        jLabel.paint(graphics2D);
        Icon icon = jLabel.getIcon();
        int n = icon == null ? 0 : icon.getIconWidth() + jLabel.getIconTextGap();
        graphics2D.setComposite(AlphaComposite.getInstance(4, 0.5f));
        graphics2D.setPaint(new GradientPaint(n, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        graphics2D.fillRect(n, 0, this.getWidth(), this._imgGhost.getHeight());
        graphics2D.dispose();
        this.setSelectionPath(treePath);
        TdkTransferableTreePath tdkTransferableTreePath = new TdkTransferableTreePath(treePath);
        this._pathSource = treePath;
        dragGestureEvent.startDrag(null, this._imgGhost, new Point(5, 5), tdkTransferableTreePath, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        int n;
        if (dragSourceDropEvent.getDropSuccess() && (n = dragSourceDropEvent.getDropAction()) == 2) {
            this._pathSource = null;
            this.cancelEditing();
        }
    }

    protected abstract void updateTreeNodes(TreePath var1, TreePath var2, boolean var3);

    protected abstract boolean isDropAcceptable(TreePath var1, TreePath var2, boolean var3);

    @Override
    public void autoscroll(Point point) {
        int n = this.getClosestRowForLocation(point.x, point.y);
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.getParent().getBounds();
        n = point.y + rectangle.y <= 12 ? (n < 1 ? 0 : n - 1) : (n < this.getRowCount() - 1 ? n + 1 : n);
        this.scrollRowToVisible(n);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getParent().getBounds();
        Rectangle rectangle2 = this.getParent().getParent().getBounds();
        return new Insets(rectangle2.y - rectangle.y + 12, rectangle2.x - rectangle.x + 12, rectangle.height - rectangle2.height - rectangle2.y + rectangle.y + 12, rectangle.width - rectangle2.width - rectangle2.x + rectangle.x + 12);
    }

    protected boolean isRootPath(TreePath treePath) {
        return this.isRootVisible() && this.getRowForPath(treePath) == 0;
    }

    public DragGestureRecognizer getDragGestureRecognizer() {
        return this.dragGestureRecognizer;
    }

    class CDropTargetListener
    implements DropTargetListener {
        private TreePath _pathLast = null;
        private Rectangle2D _raCueLine = new Rectangle2D.Float();
        private Rectangle2D _raGhost = new Rectangle2D.Float();
        private Color _colorCueLine;
        private Point _ptLast = new Point();
        private Timer _timerHover;
        private int _nLeftRight = 0;

        public CDropTargetListener() {
            this._colorCueLine = UIManager.getColor("Tree.selectionBackground");
            this._timerHover = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CDropTargetListener.this._nLeftRight = 0;
                    if (TdkDnDTree.this.isRootPath(CDropTargetListener.this._pathLast)) {
                        return;
                    }
                    if (!TdkDnDTree.this.isExpanded(CDropTargetListener.this._pathLast)) {
                        TdkDnDTree.this.expandPath(CDropTargetListener.this._pathLast);
                    } else {
                        TdkDnDTree.this.collapsePath(CDropTargetListener.this._pathLast);
                    }
                }
            });
            this._timerHover.setRepeats(false);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.isDragAcceptable(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (!DragSource.isDragImageSupported()) {
                TdkDnDTree.this.repaint(this._raGhost.getBounds());
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            if (point.equals(this._ptLast)) {
                return;
            }
            if (!this.isDropAcceptable(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(2);
            }
            int n = point.x - this._ptLast.x;
            if (this._nLeftRight > 0 && n < 0 || this._nLeftRight < 0 && n > 0) {
                this._nLeftRight = 0;
            }
            this._nLeftRight += n;
            this._ptLast = point;
            Graphics2D graphics2D = (Graphics2D)TdkDnDTree.this.getGraphics();
            if (!DragSource.isDragImageSupported()) {
                TdkDnDTree.this.paintImmediately(this._raGhost.getBounds());
                this._raGhost.setRect(point.x - ((TdkDnDTree)TdkDnDTree.this)._ptOffset.x, point.y - ((TdkDnDTree)TdkDnDTree.this)._ptOffset.y, TdkDnDTree.this._imgGhost.getWidth(), TdkDnDTree.this._imgGhost.getHeight());
                graphics2D.drawImage(TdkDnDTree.this._imgGhost, AffineTransform.getTranslateInstance(this._raGhost.getX(), this._raGhost.getY()), null);
            } else {
                TdkDnDTree.this.paintImmediately(this._raCueLine.getBounds());
            }
            TreePath treePath = TdkDnDTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath != this._pathLast) {
                this._nLeftRight = 0;
                this._pathLast = treePath;
                this._timerHover.restart();
            }
            Rectangle rectangle = TdkDnDTree.this.getPathBounds(treePath);
            TdkLegendElement tdkLegendElement = (TdkLegendElement)treePath.getLastPathComponent();
            if (tdkLegendElement instanceof TdkThemeGroupLegendElement && !this.isOnTopHalf(treePath, point)) {
                graphics2D.setColor(this._colorCueLine);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(1.5f));
                this._raCueLine.setRect(rectangle);
                graphics2D.setColor(this._colorCueLine);
                graphics2D.draw(this._raCueLine);
                this._raCueLine.setRect(rectangle.x - 5, rectangle.y - 5, (int)rectangle.getWidth() + 10, (int)rectangle.getHeight() + 10);
                graphics2D.setStroke(stroke);
            } else {
                if (TdkDnDTree.this.isExpanded(treePath) && !this.isOnTopHalf(treePath, point) || treePath.getLastPathComponent() instanceof TdkViewLegendElement) {
                    Object[] objectArray = ((DefaultTreeModel)TdkDnDTree.this.getModel()).getPathToRoot(tdkLegendElement.getChildAt(0));
                    treePath = new TreePath(objectArray);
                    rectangle = TdkDnDTree.this.getPathBounds(treePath);
                }
                int n2 = rectangle.y;
                if (!this.isOnTopHalf(treePath, point) || treePath.getLastPathComponent() instanceof TdkViewLegendElement) {
                    n2 += (int)rectangle.getHeight();
                }
                this._raCueLine.setRect(rectangle.x, n2, rectangle.getWidth(), 2.0);
                graphics2D.setColor(this._colorCueLine);
                graphics2D.fill(this._raCueLine);
            }
            this._raGhost = this._raGhost.createUnion(this._raCueLine);
        }

        private boolean isOnTopHalf(TreePath treePath, Point point) {
            Rectangle rectangle = TdkDnDTree.this.getPathBounds(treePath);
            return (double)point.y < rectangle.getCenterY();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.isDragAcceptable(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this._timerHover.stop();
            if (!this.isDropAcceptable(dropTargetDropEvent)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                DataFlavor dataFlavor = dataFlavorArray[i];
                if (!dataFlavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    TreePath treePath = (TreePath)transferable.getTransferData(dataFlavor);
                    Point point = dropTargetDropEvent.getLocation();
                    TreePath treePath2 = TdkDnDTree.this.getClosestPathForLocation(point.x, point.y);
                    TdkDnDTree.this.updateTreeNodes(treePath, treePath2, this.isOnTopHalf(treePath2, point));
                    break;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
                catch (IOException iOException) {
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
            }
            dropTargetDropEvent.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
            return dropTargetDragEvent.isDataFlavorSupported(TdkTransferableTreePath.TREEPATH_FLAVOR) && (dropTargetDragEvent.getDropAction() & 2) != 0;
        }

        public boolean isDropAcceptable(DropTargetDragEvent dropTargetDragEvent) {
            if (!dropTargetDragEvent.isDataFlavorSupported(TdkTransferableTreePath.TREEPATH_FLAVOR) || (dropTargetDragEvent.getDropAction() & 2) == 0) {
                return false;
            }
            Point point = dropTargetDragEvent.getLocation();
            TreePath treePath = TdkDnDTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath == null) {
                return false;
            }
            return TdkDnDTree.this.isDropAcceptable(TdkDnDTree.this._pathSource, treePath, this.isOnTopHalf(treePath, point));
        }

        public boolean isDropAcceptable(DropTargetDropEvent dropTargetDropEvent) {
            if (!dropTargetDropEvent.isDataFlavorSupported(TdkTransferableTreePath.TREEPATH_FLAVOR) || (dropTargetDropEvent.getDropAction() & 2) == 0) {
                return false;
            }
            Point point = dropTargetDropEvent.getLocation();
            TreePath treePath = TdkDnDTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath == null) {
                return false;
            }
            return TdkDnDTree.this.isDropAcceptable(TdkDnDTree.this._pathSource, treePath, this.isOnTopHalf(treePath, point));
        }
    }
}

