/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import org.tecgraf.jtdk.desktop.components.util.TdkColorChooser;

public class TdkStyleButton
extends JPanel {
    private static final AbstractBorder BORDER = new LineBorder(Color.lightGray);
    private static final Dimension COLORPLNSIZE = new Dimension(40, 16);
    private static final Dimension COLORBTNSIZE = new Dimension(16, 18);
    private boolean enabled_ = true;
    private JButton colorBtn_;
    private JPanel colorPnl_;
    private JCheckBox selectedChkBox_;

    public TdkStyleButton(boolean bl, Color color) {
        color = color == null ? Color.white : color;
        this.selectedChkBox_ = new JCheckBox();
        this.selectedChkBox_.setMargin(new Insets(0, 0, 0, 0));
        this.selectedChkBox_.setVisible(bl);
        this.colorPnl_ = new JPanel();
        this.colorPnl_.setBorder(BORDER);
        this.colorPnl_.setBackground(color);
        this.colorPnl_.setPreferredSize(COLORPLNSIZE);
        this.colorPnl_.setMaximumSize(COLORPLNSIZE);
        this.colorPnl_.setMinimumSize(COLORPLNSIZE);
        this.colorPnl_.setToolTipText(this.infDescriptionColor(color));
        this.colorBtn_ = new JButton("...");
        this.colorBtn_.setPreferredSize(COLORBTNSIZE);
        this.colorBtn_.setMaximumSize(COLORBTNSIZE);
        this.colorBtn_.setMinimumSize(COLORBTNSIZE);
        this.colorBtn_.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Color color;
                if (TdkStyleButton.this.enabled_ && mouseEvent.getSource() instanceof JButton && (color = TdkColorChooser.showDialog(TdkStyleButton.this, TdkStyleButton.this.colorPnl_.getBackground())) != null) {
                    TdkStyleButton.this.colorPnl_.setBackground(color);
                    TdkStyleButton.this.colorPnl_.setToolTipText(TdkStyleButton.this.infDescriptionColor(color));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BORDER);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0);
        this.add((Component)this.selectedChkBox_, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 100.0;
        this.add((Component)this.colorPnl_, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.colorBtn_, gridBagConstraints);
    }

    public TdkStyleButton(Color color) {
        this(false, color);
    }

    public TdkStyleButton(boolean bl) {
        this(bl, null);
    }

    public TdkStyleButton() {
        this(false, null);
    }

    private String infDescriptionColor(Color color) {
        return color != null ? "RGB (" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")" : "RGB (255, 255, 255)";
    }

    public Color getColor() {
        return this.colorPnl_.getBackground();
    }

    public void setColor(Color color) {
        this.colorPnl_.setBackground(color);
        this.colorPnl_.setToolTipText(this.infDescriptionColor(color));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled_;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled_ = bl;
        this.selectedChkBox_.setEnabled(bl);
        this.colorPnl_.setEnabled(bl);
        this.colorBtn_.setEnabled(bl);
    }

    public boolean getSelected() {
        return this.selectedChkBox_.isSelected();
    }

    public void setSelected(boolean bl) {
        this.selectedChkBox_.setSelected(bl);
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.colorBtn_.setToolTipText(string);
    }
}

