/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.components.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Arrays;
import javax.swing.tree.TreePath;

class TdkTransferableTreePath
implements Transferable {
    public static final DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "TreePath");
    private TreePath _path;
    private DataFlavor[] _flavors = new DataFlavor[]{TREEPATH_FLAVOR};

    public TdkTransferableTreePath(TreePath treePath) {
        this._path = treePath;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this._flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return Arrays.asList(this._flavors).contains(dataFlavor);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.isMimeTypeEqual(TREEPATH_FLAVOR.getMimeType())) {
            return this._path;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

