/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.prowl.url;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.prowl.api.ProwlCommand;
import net.sourceforge.prowl.api.ProwlParameter;
import net.sourceforge.prowl.url.ProwlURLBuilder;

public class DefaultProwlURLBuilder
implements ProwlURLBuilder {
    private static String PROWL_API_URL = "https://api.prowlapp.com/publicapi/";
    private ProwlCommand prowlCommand;
    private Map<ProwlParameter, String> paramMap = new HashMap<ProwlParameter, String>();

    private DefaultProwlURLBuilder() {
    }

    public static ProwlURLBuilder createUrl() {
        return new DefaultProwlURLBuilder();
    }

    @Override
    public ProwlURLBuilder useCommand(ProwlCommand command) {
        if (command != null) {
            this.prowlCommand = command;
        }
        return this;
    }

    @Override
    public ProwlURLBuilder appendParam(ProwlParameter param, String value) {
        if (param != null && value != null) {
            this.paramMap.put(param, value);
        }
        return this;
    }

    @Override
    public String getURL() {
        StringBuilder url = new StringBuilder();
        url.append(PROWL_API_URL);
        if (this.prowlCommand != null) {
            url.append(this.prowlCommand.getApiMapping());
        }
        this.appendParameters(url);
        return url.toString();
    }

    private void appendParameters(StringBuilder url) {
        if (!this.paramMap.isEmpty()) {
            url.append("?");
            boolean isFirst = true;
            for (ProwlParameter key : this.paramMap.keySet()) {
                String value = this.paramMap.get((Object)key);
                if (!isFirst) {
                    url.append("&");
                }
                url.append((Object)key);
                url.append("=");
                url.append(value);
                isFirst = false;
            }
        }
    }

    public static void setProwlApiUrl(String prowlApiUrl) {
        PROWL_API_URL = prowlApiUrl;
    }

    public static String getProwlApiUrl() {
        return PROWL_API_URL;
    }

    public String toString() {
        return this.getURL();
    }
}

