/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.link;

import org.apache.hivemind.service.BodyBuilder;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.link.DefaultLinkRenderer;

public class PopupLinkRenderer
extends DefaultLinkRenderer {
    private String _windowName;
    private String _features;

    public PopupLinkRenderer() {
    }

    public PopupLinkRenderer(String windowName, String features) {
        this._windowName = windowName;
        this._features = features;
    }

    protected String constructURL(ILinkComponent component, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return null;
        }
        String anchor = component.getAnchor();
        ILink link = component.getLink(cycle);
        String url = link.getURL(anchor, true);
        PageRenderSupport support = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)component);
        String functionName = support.getUniqueString("popup_window");
        BodyBuilder builder = new BodyBuilder();
        builder.addln("{0}=function()", (Object)functionName);
        builder.begin();
        builder.add("var newWindow = window.open({0}, {1}, {2});", (Object)TapestryUtils.enquote((String)url), (Object)TapestryUtils.enquote((String)this.getWindowName()), (Object)TapestryUtils.enquote((String)this.getFeatures()));
        builder.add("newWindow.focus();");
        builder.end();
        builder.addln(";");
        support.addBodyScript((IComponent)component, builder.toString());
        return "javascript:" + functionName + "();";
    }

    public String getWindowName() {
        return this._windowName;
    }

    public void setWindowName(String windowName) {
        this._windowName = windowName;
    }

    public String getFeatures() {
        return this._features;
    }

    public void setFeatures(String features) {
        this._features = features;
    }
}

