/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.services.impl;

import [Ljava.lang.Object;;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.services.impl.RoundedCornerGenerator;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.error.RequestExceptionReporter;
import org.apache.tapestry.services.LinkFactory;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebResponse;

public class RoundedCornerService
implements IEngineService {
    public static final String SERVICE_NAME = "rounded";
    public static final String PARM_COLOR = "c";
    public static final String PARM_BACKGROUND_COLOR = "bc";
    public static final String PARM_WIDTH = "w";
    public static final String PARM_HEIGHT = "h";
    public static final String PARM_ANGLE = "a";
    public static final String PARM_SHADOW_WIDTH = "sw";
    public static final String PARM_SHADOW_OPACITY = "o";
    public static final String PARM_SHADOW_SIDE = "s";
    public static final String PARM_WHOLE_SHADOW = "shadow";
    public static final String PARM_ARC_HEIGHT = "ah";
    public static final String PARM_ARC_WIDTH = "aw";
    private static final long MONTH_SECONDS = 2592000L;
    private static final long EXPIRES = System.currentTimeMillis() + 31536000000L;
    private RequestExceptionReporter _exceptionReporter;
    private LinkFactory _linkFactory;
    private WebRequest _request;
    private WebResponse _response;
    private RoundedCornerGenerator _generator = new RoundedCornerGenerator();
    private Map _imageCache = new HashMap();
    private Log _log;
    private String _nonTransparentFormatName = "gif";

    public void initialize() {
        String[] names = ImageIO.getWriterFormatNames();
        boolean supportsGif = false;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].toLowerCase().equals("gif")) continue;
            supportsGif = true;
            break;
        }
        if (!supportsGif) {
            this._nonTransparentFormatName = "jpeg";
        }
    }

    public ILink getLink(boolean post, Object parameter) {
        Defense.notNull((Object)parameter, (String)"parameter");
        Defense.isAssignable((Object)parameter, (Class)Object;.class, (String)"parameter");
        Object[] parms = (Object[])parameter;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("service", this.getName());
        parameters.put("sp", parms);
        return this._linkFactory.constructLink((IEngineService)this, post, parameters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(IRequestCycle cycle) throws IOException {
        if (this._request.getHeader("If-Modified-Since") != null) {
            this._response.setStatus(304);
            return;
        }
        String color = cycle.getParameter(PARM_COLOR);
        String bgColor = cycle.getParameter(PARM_BACKGROUND_COLOR);
        int width = this.getIntParam(cycle.getParameter(PARM_WIDTH));
        int height = this.getIntParam(cycle.getParameter(PARM_HEIGHT));
        String angle = cycle.getParameter(PARM_ANGLE);
        int shadowWidth = this.getIntParam(cycle.getParameter(PARM_SHADOW_WIDTH));
        float shadowOpacity = this.getFloatParam(cycle.getParameter(PARM_SHADOW_OPACITY));
        String side = cycle.getParameter(PARM_SHADOW_SIDE);
        boolean wholeShadow = Boolean.valueOf(cycle.getParameter(PARM_WHOLE_SHADOW));
        float arcWidth = this.getFloatParam(cycle.getParameter(PARM_ARC_WIDTH));
        float arcHeight = this.getFloatParam(cycle.getParameter(PARM_ARC_HEIGHT));
        String hashKey = color + bgColor + width + height + angle + shadowWidth + shadowOpacity + side + wholeShadow;
        ByteArrayOutputStream bo = null;
        try {
            String type = bgColor != null ? this._nonTransparentFormatName : "png";
            byte[] data = (byte[])this._imageCache.get(hashKey);
            if (data != null) {
                this.writeImageResponse(data, type);
                return;
            }
            BufferedImage image = null;
            image = wholeShadow ? this._generator.buildShadow(color, bgColor, width, height, arcWidth, arcHeight, shadowWidth, shadowOpacity) : (side != null ? this._generator.buildSideShadow(side, shadowWidth, shadowOpacity) : this._generator.buildCorner(color, bgColor, width, height, angle, shadowWidth, shadowOpacity));
            bo = new ByteArrayOutputStream();
            boolean success = ImageIO.write((RenderedImage)image, type, bo);
            data = bo.toByteArray();
            if (!success || data == null || data.length < 1) {
                this._log.error((Object)("Image generated had zero length byte array or failed to convert from parameters of:\n[color:" + color + ", bgColor:" + bgColor + ", width:" + width + ", height:" + height + ", angle:" + angle + ", shadowWidth:" + shadowWidth + ", shadowOpacity:" + shadowOpacity + ", side:" + side + ", wholeShadow: " + wholeShadow + ", arcWidth: " + arcWidth + ", arcHeight:" + arcHeight + "\n image: " + image));
                this._response.setStatus(500);
                return;
            }
            this._imageCache.put(hashKey, data);
            this.writeImageResponse(data, type);
            return;
        }
        catch (IOException eof) {
            return;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this._exceptionReporter.reportRequestException("Error creating image.", ex);
            return;
        }
        finally {
            try {
                if (bo != null) {
                    bo.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeImageResponse(byte[] data, String type) throws Exception {
        OutputStream os = null;
        try {
            this._response.setDateHeader("Expires", EXPIRES);
            this._response.setHeader("Cache-Control", "public, max-age=7776000");
            this._response.setContentLength(data.length);
            os = this._response.getOutputStream(new ContentType("image/" + type));
            os.write(data);
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    private int getIntParam(String value) {
        if (value == null) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    private float getFloatParam(String value) {
        if (value == null) {
            return -1.0f;
        }
        return Float.valueOf(value).floatValue();
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public void setExceptionReporter(RequestExceptionReporter exceptionReporter) {
        this._exceptionReporter = exceptionReporter;
    }

    public void setLinkFactory(LinkFactory linkFactory) {
        this._linkFactory = linkFactory;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }

    public void setResponse(WebResponse response) {
        this._response = response;
    }

    public void setLog(Log log) {
        this._log = log;
    }
}

