/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.components.inserted;

import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.contrib.table.components.Table;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableModel;
import org.apache.tapestry.contrib.table.model.ITableModelSource;
import org.apache.tapestry.contrib.table.model.ITableRendererListener;
import org.apache.tapestry.contrib.table.model.ITableSortingState;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;

public abstract class SimpleTableColumnSortImage
extends BaseComponent
implements PageDetachListener,
ITableRendererListener {
    private ITableModelSource m_objModelSource;
    private ITableColumn m_objColumn;

    public SimpleTableColumnSortImage() {
        this.init();
    }

    public abstract Table getTable();

    public void pageDetached(PageEvent arg0) {
        this.init();
    }

    private void init() {
        this.m_objModelSource = null;
        this.m_objColumn = null;
    }

    public void initializeRenderer(IRequestCycle objCycle, ITableModelSource objSource, ITableColumn objColumn, Object objRow) {
        this.m_objModelSource = objSource;
        this.m_objColumn = objColumn;
    }

    public void prepareForRender(IRequestCycle cycle) {
        if (this.getTable() == null) {
            throw Tapestry.createRequiredParameterException((IComponent)this, (String)"table");
        }
        this.m_objModelSource = this.getTable();
        this.m_objColumn = this.getTable().getTableColumn();
    }

    public ITableModel getTableModel() {
        return this.m_objModelSource.getTableModel();
    }

    public IAsset getSortImage() {
        IAsset objImageAsset;
        IRequestCycle objCycle = this.getPage().getRequestCycle();
        ITableSortingState objSortingState = this.getTableModel().getSortingState();
        if (!objSortingState.getSortOrder()) {
            objImageAsset = (IAsset)objCycle.getAttribute("org.apache.tapestry.contrib.table.components.TableColumns.arrowUp");
            if (objImageAsset == null) {
                objImageAsset = this.getAsset("sortUp");
            }
        } else {
            objImageAsset = (IAsset)objCycle.getAttribute("org.apache.tapestry.contrib.table.components.TableColumns.arrowDown");
            if (objImageAsset == null) {
                objImageAsset = this.getAsset("sortDown");
            }
        }
        return objImageAsset;
    }

    public boolean getIsSorted() {
        ITableSortingState objSortingState = this.getTableModel().getSortingState();
        String strSortColumn = objSortingState.getSortColumn();
        return this.m_objColumn.getColumnName().equals(strSortColumn);
    }
}

