/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.simple;

import java.util.StringTokenizer;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.contrib.table.components.TableMessages;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableState;
import org.apache.tapestry.services.DataSqueezer;
import org.apache.tapestry.util.io.SqueezeAdaptor;

public class SimpleTableStateAdaptor
implements SqueezeAdaptor {
    private static final String PREFIX = "t";

    public String getPrefix() {
        return PREFIX;
    }

    public Class getDataClass() {
        return SimpleTableState.class;
    }

    public String squeeze(DataSqueezer squeezer, Object data) {
        SimpleTableState objState = (SimpleTableState)data;
        StringBuffer buf = new StringBuffer();
        buf.append(objState.getPagingState().getPageSize());
        buf.append(":");
        buf.append(objState.getPagingState().getCurrentPage());
        buf.append(":");
        String strSortColumn = objState.getSortingState().getSortColumn();
        if (strSortColumn == null) {
            strSortColumn = "";
        }
        buf.append(strSortColumn);
        buf.append(":");
        buf.append(objState.getSortingState().getSortOrder() ? (char)'T' : 'F');
        return buf.toString();
    }

    public Object unsqueeze(DataSqueezer squeezer, String string) {
        StringTokenizer strTok = new StringTokenizer(string, ":");
        if (strTok.countTokens() != 4) {
            throw new ApplicationRuntimeException(TableMessages.invalidTableStateFormat(string));
        }
        int nPageSize = Integer.parseInt(strTok.nextToken());
        int nCurrentPage = Integer.parseInt(strTok.nextToken());
        String strSortColumn = strTok.nextToken();
        if (strSortColumn.equals("")) {
            strSortColumn = null;
        }
        boolean bSortOrder = strTok.nextToken().equals("T");
        return new SimpleTableState(nPageSize, nCurrentPage, strSortColumn, bSortOrder);
    }
}

