/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.tree.components.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableModel;
import org.apache.tapestry.contrib.table.model.ITableSessionStateManager;
import org.apache.tapestry.contrib.table.model.simple.SimpleListTableDataModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableSessionStateManager;
import org.apache.tapestry.contrib.tree.components.table.TreeTableColumn;
import org.apache.tapestry.contrib.tree.model.ITreeDataModel;
import org.apache.tapestry.contrib.tree.model.ITreeModel;
import org.apache.tapestry.contrib.tree.model.ITreeModelSource;
import org.apache.tapestry.contrib.tree.model.ITreeRowSource;
import org.apache.tapestry.contrib.tree.model.TreeRowObject;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;

public abstract class TreeTableDataView
extends BaseComponent
implements ITreeRowSource,
PageDetachListener {
    private int m_nTreeDeep = -1;
    private TreeRowObject m_objTreeRowObject = null;
    private ArrayList m_arrAllExpandedNodes = null;

    public TreeTableDataView() {
        this.initialize();
    }

    public void initialize() {
        this.m_nTreeDeep = -1;
        this.m_objTreeRowObject = null;
        this.m_arrAllExpandedNodes = null;
    }

    public void pageDetached(PageEvent event) {
        this.initialize();
    }

    public abstract ITreeModelSource getTreeViewParameter();

    public ITreeModelSource getTreeModelSource() {
        ITreeModelSource objSource = (ITreeModelSource)this.getPage().getRequestCycle().getAttribute("org.apache.tapestry.contrib.tree.model.ITreeModelSource");
        return objSource == null ? this.getTreeViewParameter() : objSource;
    }

    public List generateNodeList() {
        if (this.m_arrAllExpandedNodes == null) {
            ArrayList arrAllExpandedNodes = new ArrayList();
            ITreeModelSource objTreeModelSource = this.getTreeModelSource();
            ITreeModel objTreeModel = objTreeModelSource.getTreeModel();
            ITreeDataModel objTreeDataModel = objTreeModel.getTreeDataModel();
            Object objRoot = objTreeDataModel.getRoot();
            Object objRootUID = objTreeDataModel.getUniqueKey(objRoot, null);
            if (this.getShowRootNode()) {
                this.walkTree(arrAllExpandedNodes, objRoot, objRootUID, 0, objTreeModel, 4, new int[0], true);
            } else {
                int nChildenCount = objTreeModel.getTreeDataModel().getChildCount(objRoot);
                int nRowPossiotionType = nChildenCount == 1 ? 4 : 1;
                boolean bFirst = true;
                Iterator iter = objTreeModel.getTreeDataModel().getChildren(objRoot);
                while (iter.hasNext()) {
                    boolean bChildLast;
                    Object objChild = iter.next();
                    Object objChildUID = objTreeModel.getTreeDataModel().getUniqueKey(objChild, objRoot);
                    boolean bl = bChildLast = !iter.hasNext();
                    if (!bFirst) {
                        nRowPossiotionType = bChildLast ? 3 : 2;
                    }
                    this.walkTree(arrAllExpandedNodes, objChild, objChildUID, 0, objTreeModel, nRowPossiotionType, new int[0], bChildLast);
                    bFirst = false;
                }
            }
            this.m_arrAllExpandedNodes = arrAllExpandedNodes;
        }
        return this.m_arrAllExpandedNodes;
    }

    public void walkTree(ArrayList arrAllExpandedNodes, Object objParent, Object objParentUID, int nDepth, ITreeModel objTreeModel, int nRowPossiotionType, int[] arrConnectImages, boolean bLast) {
        int rowPositionType = nRowPossiotionType;
        this.m_nTreeDeep = nDepth;
        int nNumberOfChildren = objTreeModel.getTreeDataModel().getChildCount(objParent);
        boolean bLeaf = nNumberOfChildren == 0;
        TreeRowObject objTreeRowObject = new TreeRowObject(objParent, objParentUID, nDepth, bLeaf, rowPositionType, arrConnectImages);
        arrAllExpandedNodes.add(objTreeRowObject);
        boolean bContain = objTreeModel.getTreeStateModel().isUniqueKeyExpanded(objParentUID);
        if (bContain) {
            Iterator colChildren;
            int[] arrConnectImagesNew = new int[arrConnectImages.length + 1];
            System.arraycopy(arrConnectImages, 0, arrConnectImagesNew, 0, arrConnectImages.length);
            arrConnectImagesNew[arrConnectImagesNew.length - 1] = bLast ? 1 : 2;
            Iterator iter = colChildren = objTreeModel.getTreeDataModel().getChildren(objParent);
            while (iter.hasNext()) {
                Object objChild = iter.next();
                Object objChildUID = objTreeModel.getTreeDataModel().getUniqueKey(objChild, objParentUID);
                boolean bChildLast = !iter.hasNext();
                rowPositionType = bChildLast ? 3 : 2;
                this.walkTree(arrAllExpandedNodes, objChild, objChildUID, nDepth + 1, objTreeModel, rowPositionType, arrConnectImagesNew, bChildLast);
            }
        }
    }

    public int getTreeDeep() {
        return this.m_nTreeDeep;
    }

    public ITableModel getTableModel() {
        return this.createTableModel();
    }

    private ITableModel createTableModel() {
        List arrAllNodes = this.generateNodeList();
        Object[] arrAllExpandedNodes = new Object[arrAllNodes.size()];
        arrAllNodes.toArray(arrAllExpandedNodes);
        SimpleTableModel objTableModel = new SimpleTableModel(arrAllExpandedNodes, this.getTableColunms());
        objTableModel.getPagingState().setPageSize(this.getEntriesPerTablePage());
        return objTableModel;
    }

    public ITableColumn[] getTableColunms() {
        ArrayList<TreeTableColumn> arrColumnsList = new ArrayList<TreeTableColumn>();
        arrColumnsList.add(new TreeTableColumn("Name", false, null));
        List arrTableColunms = this.getTableColumnsParameter();
        if (arrTableColunms != null) {
            arrColumnsList.addAll(arrTableColunms);
        }
        ITableColumn[] arrColumns = new ITableColumn[arrColumnsList.size()];
        arrColumnsList.toArray(arrColumns);
        return arrColumns;
    }

    public abstract List getTableColumnsParameter();

    public abstract int getEntriesPerTablePage();

    public TreeRowObject getTreeRow() {
        return this.getTreeRowObject();
    }

    public ITableSessionStateManager getTableSessionStateManager() {
        SimpleListTableDataModel objDataModel = new SimpleListTableDataModel(this.generateNodeList());
        SimpleTableColumnModel objColumnModel = new SimpleTableColumnModel(this.getTableColunms());
        SimpleTableSessionStateManager objStateManager = new SimpleTableSessionStateManager(objDataModel, objColumnModel);
        return objStateManager;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Object objExistedTreeModelSource = cycle.getAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource");
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", (Object)this);
        super.renderComponent(writer, cycle);
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", objExistedTreeModelSource);
    }

    public void renderBody(IMarkupWriter writer, IRequestCycle cycle) {
        Object objExistedTreeModelSource = cycle.getAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource");
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", (Object)this);
        super.renderBody(writer, cycle);
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", objExistedTreeModelSource);
    }

    public TreeRowObject getTreeRowObject() {
        return this.m_objTreeRowObject;
    }

    public void setTreeRowObject(TreeRowObject object) {
        this.m_objTreeRowObject = object;
    }

    public abstract boolean getShowRootNode();
}

