/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;
import org.wololo.geojson.Feature;
import org.wololo.geojson.GeoJSONFactory;
import org.wololo.jts2geojson.GeoJSONReader;

public class PointFormatMapper
extends FormatMapper
implements FlatMapFunction<Iterator<String>, Object> {
    public PointFormatMapper(FileDataSplitter Splitter, boolean carryInputData) {
        super(Splitter, carryInputData);
    }

    public PointFormatMapper(Integer startOffset, Integer endOffset, FileDataSplitter Splitter, boolean carryInputData) {
        super(startOffset, endOffset, Splitter, carryInputData);
    }

    public Iterator<Object> call(Iterator<String> stringIterator) throws Exception {
        MultiPoint multiSpatialObjects = null;
        ArrayList<Point> result = new ArrayList<Point>();
        block8: while (stringIterator.hasNext()) {
            String line = stringIterator.next();
            try {
                switch (this.splitter) {
                    case CSV: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        Coordinate coordinate = new Coordinate(Double.parseDouble((String)this.lineSplitList.get(0 + this.startOffset)), Double.parseDouble((String)this.lineSplitList.get(1 + this.startOffset)));
                        this.spatialObject = this.fact.createPoint(coordinate);
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((Point)this.spatialObject);
                        break;
                    }
                    case TSV: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        Coordinate coordinate = new Coordinate(Double.parseDouble((String)this.lineSplitList.get(0 + this.startOffset)), Double.parseDouble((String)this.lineSplitList.get(1 + this.startOffset)));
                        this.spatialObject = this.fact.createPoint(coordinate);
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((Point)this.spatialObject);
                        break;
                    }
                    case GEOJSON: {
                        GeoJSONReader reader = new GeoJSONReader();
                        this.spatialObject = reader.read(line);
                        if (line.contains("Feature")) {
                            Feature feature = (Feature)GeoJSONFactory.create(line);
                            this.spatialObject = reader.read(feature.getGeometry());
                        } else {
                            this.spatialObject = reader.read(line);
                        }
                        if (this.spatialObject instanceof MultiPoint) {
                            multiSpatialObjects = (MultiPoint)this.spatialObject;
                            for (int i = 0; i < multiSpatialObjects.getNumGeometries(); ++i) {
                                this.spatialObject = multiSpatialObjects.getGeometryN(i);
                                if (this.carryInputData) {
                                    this.spatialObject.setUserData(line);
                                }
                                result.add((Point)this.spatialObject);
                            }
                            continue block8;
                        }
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((Point)this.spatialObject);
                        break;
                    }
                    case WKT: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        WKTReader wktreader = new WKTReader();
                        this.spatialObject = wktreader.read((String)this.lineSplitList.get(this.startOffset));
                        if (this.spatialObject instanceof MultiPoint) {
                            multiSpatialObjects = (MultiPoint)this.spatialObject;
                            for (int i = 0; i < multiSpatialObjects.getNumGeometries(); ++i) {
                                this.spatialObject = multiSpatialObjects.getGeometryN(i);
                                if (this.carryInputData) {
                                    this.spatialObject.setUserData(line);
                                }
                                result.add((Point)this.spatialObject);
                            }
                            continue block8;
                        }
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add((Point)this.spatialObject);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.iterator();
    }
}

