/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.TypeUnknownException;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.PrimitiveShape;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShapeInputFormat;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShapeKey;
import scala.Tuple2;

public class ShapefileRDD
implements Serializable {
    private JavaRDD<Geometry> shapeRDD = null;
    public static GeometryFactory geometryFactory;
    private static final Function<Tuple2<ShapeKey, PrimitiveShape>, Geometry> PrimitiveToShape;
    private final VoidFunction<Geometry> PrintShape = new VoidFunction<Geometry>(){

        public void call(Geometry shape) throws Exception {
            System.out.println(shape.toText());
        }
    };

    public ShapefileRDD(JavaSparkContext sparkContext, String filePath) {
        geometryFactory = new GeometryFactory();
        JavaPairRDD shapePrimitiveRdd = sparkContext.newAPIHadoopFile(filePath, ShapeInputFormat.class, ShapeKey.class, PrimitiveShape.class, sparkContext.hadoopConfiguration());
        this.shapeRDD = shapePrimitiveRdd.map(PrimitiveToShape);
    }

    public JavaRDD<Geometry> getShapeRDD() {
        return this.shapeRDD;
    }

    public JavaRDD<Point> getPointRDD() {
        return this.shapeRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, Point>(){

            public Iterator<Point> call(Geometry spatialObject) throws Exception {
                ArrayList<Point> result = new ArrayList<Point>();
                if (spatialObject instanceof MultiPoint) {
                    MultiPoint multiObjects = (MultiPoint)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        result.add((Point)multiObjects.getGeometryN(i));
                    }
                } else if (spatialObject instanceof Point) {
                    result.add((Point)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getPointRDD] the object type is not Point or MultiPoint type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        });
    }

    public JavaRDD<Polygon> getPolygonRDD() {
        return this.shapeRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, Polygon>(){

            public Iterator<Polygon> call(Geometry spatialObject) throws Exception {
                ArrayList<Polygon> result = new ArrayList<Polygon>();
                if (spatialObject instanceof MultiPolygon) {
                    MultiPolygon multiObjects = (MultiPolygon)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        result.add((Polygon)multiObjects.getGeometryN(i));
                    }
                } else if (spatialObject instanceof Polygon) {
                    result.add((Polygon)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getPolygonRDD] the object type is not Polygon or MultiPolygon type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        });
    }

    public JavaRDD<LineString> getLineStringRDD() {
        return this.shapeRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, LineString>(){

            public Iterator<LineString> call(Geometry spatialObject) throws Exception {
                ArrayList<LineString> result = new ArrayList<LineString>();
                if (spatialObject instanceof MultiLineString) {
                    MultiLineString multiObjects = (MultiLineString)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        result.add((LineString)multiObjects.getGeometryN(i));
                    }
                } else if (spatialObject instanceof LineString) {
                    result.add((LineString)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getLineStringRDD] the object type is not LineString or MultiLineString type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        });
    }

    static {
        PrimitiveToShape = new Function<Tuple2<ShapeKey, PrimitiveShape>, Geometry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Geometry call(Tuple2<ShapeKey, PrimitiveShape> primitiveTuple) {
                Geometry shape = null;
                try {
                    shape = ((PrimitiveShape)primitiveTuple._2()).getShape(geometryFactory);
                    return shape;
                }
                catch (TypeUnknownException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    return shape;
                }
            }
        };
    }
}

