/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;

public class ByteBufferReader
extends ShapeReader {
    private ByteBuffer buffer = null;

    public ByteBufferReader(byte[] bytes, boolean endianOrder) {
        this.buffer = ByteBuffer.wrap(bytes);
        if (endianOrder) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public double readDouble() throws IOException {
        return this.buffer.getDouble();
    }

    @Override
    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    @Override
    public void read(byte[] bytes) throws IOException {
        this.buffer.get(bytes);
    }

    @Override
    public void read(byte[] bytes, int offset, int len) throws IOException {
        this.buffer.get(bytes, offset, len);
    }

    @Override
    public void read(double[] doubles) throws IOException {
        DoubleBuffer doubleBuffer = this.buffer.asDoubleBuffer();
        doubleBuffer.get(doubles);
    }

    @Override
    public void skip(int n) throws IOException {
        this.buffer.position(this.buffer.position() + n);
    }
}

