/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.datasyslab.geospark.spatialPartitioning.quadtree.QuadRectangle;
import org.datasyslab.geospark.spatialPartitioning.quadtree.StandardQuadTree;

public class QuadtreePartitioning
implements Serializable {
    private StandardQuadTree<Integer> partitionTree = null;

    public QuadtreePartitioning(List SampleList, Envelope boundary, int partitions) throws Exception {
        StandardQuadTree.maxItemByNode = SampleList.size() / partitions;
        StandardQuadTree.maxLevel = 100000;
        this.partitionTree = new StandardQuadTree(new QuadRectangle(boundary.getMinX(), boundary.getMinY(), boundary.getWidth(), boundary.getHeight()), 0);
        for (int i = 0; i < SampleList.size(); ++i) {
            Comparable spatialObject;
            if (SampleList.get(i) instanceof Envelope) {
                spatialObject = (Envelope)SampleList.get(i);
                this.partitionTree.insert(new QuadRectangle((Envelope)spatialObject), 1);
                continue;
            }
            if (SampleList.get(i) instanceof Geometry) {
                spatialObject = (Geometry)SampleList.get(i);
                this.partitionTree.insert(new QuadRectangle(((Geometry)spatialObject).getEnvelopeInternal()), 1);
                continue;
            }
            throw new Exception("[QuadtreePartitioning][Constrcutor] Unsupported spatial object type");
        }
        HashSet<Integer> uniqueIdList = new HashSet<Integer>();
        this.partitionTree.getAllLeafNodeUniqueId(uniqueIdList);
        HashMap<Integer, Integer> serialIdMapping = this.partitionTree.getSeriaIdMapping(uniqueIdList);
        this.partitionTree.decidePartitionSerialId(serialIdMapping);
    }

    public QuadtreePartitioning(List SampleList, Envelope boundary, int partitions, int minTreeLevel) throws Exception {
        StandardQuadTree.maxItemByNode = SampleList.size() / partitions;
        StandardQuadTree.maxLevel = 100000;
        this.partitionTree = new StandardQuadTree(new QuadRectangle(boundary.getMinX(), boundary.getMinY(), boundary.getWidth(), boundary.getHeight()), 0);
        this.partitionTree.forceGrowUp(minTreeLevel);
        for (int i = 0; i < SampleList.size(); ++i) {
            Comparable spatialObject;
            if (SampleList.get(i) instanceof Envelope) {
                spatialObject = (Envelope)SampleList.get(i);
                this.partitionTree.insert(new QuadRectangle((Envelope)spatialObject), 1);
                continue;
            }
            if (SampleList.get(i) instanceof Geometry) {
                spatialObject = (Geometry)SampleList.get(i);
                this.partitionTree.insert(new QuadRectangle(((Geometry)spatialObject).getEnvelopeInternal()), 1);
                continue;
            }
            throw new Exception("[QuadtreePartitioning][Constrcutor] Unsupported spatial object type");
        }
        HashSet<Integer> uniqueIdList = new HashSet<Integer>();
        this.partitionTree.getAllLeafNodeUniqueId(uniqueIdList);
        HashMap<Integer, Integer> serialIdMapping = this.partitionTree.getSeriaIdMapping(uniqueIdList);
        this.partitionTree.decidePartitionSerialId(serialIdMapping);
    }

    public StandardQuadTree getPartitionTree() {
        return this.partitionTree;
    }
}

