/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.datasyslab.geospark.spatialPartitioning.quadtree.QuadNode;
import org.datasyslab.geospark.spatialPartitioning.quadtree.QuadRectangle;

public class StandardQuadTree<T>
implements Serializable {
    ArrayList<QuadNode<T>> nodes = new ArrayList();
    private QuadRectangle zone;
    private int serialId = -1;
    public static int maxItemByNode = 5;
    public static int maxLevel = 10;
    int level;
    int nodeNum = 0;
    StandardQuadTree<T>[] regions;
    public static final int REGION_SELF = -1;
    public static final int REGION_NW = 0;
    public static final int REGION_NE = 1;
    public static final int REGION_SW = 2;
    public static final int REGION_SE = 3;

    public StandardQuadTree(QuadRectangle definition, int level) {
        this.zone = definition;
        this.nodes = new ArrayList();
        this.level = level;
    }

    protected QuadRectangle getZone() {
        return this.zone;
    }

    private int findRegion(QuadRectangle r, boolean split) {
        int region = -1;
        if (this.nodeNum >= maxItemByNode && this.level < maxLevel) {
            if (this.regions == null && split) {
                this.split();
            }
            if (this.regions != null) {
                if (this.regions[0].getZone().contains(r)) {
                    region = 0;
                } else if (this.regions[1].getZone().contains(r)) {
                    region = 1;
                } else if (this.regions[2].getZone().contains(r)) {
                    region = 2;
                } else if (this.regions[3].getZone().contains(r)) {
                    region = 3;
                }
            }
        }
        return region;
    }

    private int findRegion(int x, int y) {
        int region = -1;
        if (this.regions != null) {
            if (this.regions[0].getZone().contains(x, y)) {
                region = 0;
            } else if (this.regions[1].getZone().contains(x, y)) {
                region = 1;
            } else if (this.regions[2].getZone().contains(x, y)) {
                region = 2;
            } else if (this.regions[3].getZone().contains(x, y)) {
                region = 3;
            }
        }
        return region;
    }

    private void split() {
        this.regions = new StandardQuadTree[4];
        double newWidth = this.zone.width / 2.0;
        double newHeight = this.zone.height / 2.0;
        int newLevel = this.level + 1;
        this.regions[0] = new StandardQuadTree<T>(new QuadRectangle(this.zone.x, this.zone.y + this.zone.height / 2.0, newWidth, newHeight), newLevel);
        this.regions[1] = new StandardQuadTree<T>(new QuadRectangle(this.zone.x + this.zone.width / 2.0, this.zone.y + this.zone.height / 2.0, newWidth, newHeight), newLevel);
        this.regions[2] = new StandardQuadTree<T>(new QuadRectangle(this.zone.x, this.zone.y, newWidth, newHeight), newLevel);
        this.regions[3] = new StandardQuadTree<T>(new QuadRectangle(this.zone.x + this.zone.width / 2.0, this.zone.y, newWidth, newHeight), newLevel);
    }

    public void forceGrowUp(int minLevel) {
        assert (minLevel >= 1);
        this.split();
        this.nodeNum = maxItemByNode;
        if (this.level + 1 >= minLevel) {
            return;
        }
        this.regions[0].forceGrowUp(minLevel);
        this.regions[1].forceGrowUp(minLevel);
        this.regions[2].forceGrowUp(minLevel);
        this.regions[3].forceGrowUp(minLevel);
    }

    public void insert(QuadRectangle r, T element) {
        int region = this.findRegion(r, true);
        if (region == -1 || this.level == maxLevel) {
            this.nodes.add(new QuadNode<T>(r, element));
            ++this.nodeNum;
            return;
        }
        this.regions[region].insert(r, element);
        if (this.nodeNum >= maxItemByNode && this.level < maxLevel) {
            ArrayList<QuadNode<T>> tempNodes = new ArrayList<QuadNode<T>>();
            int length = this.nodes.size();
            for (int i = 0; i < length; ++i) {
                tempNodes.add(this.nodes.get(i));
            }
            this.nodes.clear();
            for (QuadNode quadNode : tempNodes) {
                this.insert(quadNode.r, quadNode.element);
            }
        }
    }

    public ArrayList<T> getElements(ArrayList<T> list, QuadRectangle r) {
        int region = this.findRegion(r, false);
        int length = this.nodes.size();
        for (int i = 0; i < length; ++i) {
            list.add(this.nodes.get((int)i).element);
        }
        if (region != -1) {
            this.regions[region].getElements(list, r);
        } else {
            this.getAllElements(list, true);
        }
        return list;
    }

    public ArrayList<T> getAllElements(ArrayList<T> list, boolean firstCall) {
        if (this.regions != null) {
            this.regions[0].getAllElements(list, false);
            this.regions[1].getAllElements(list, false);
            this.regions[2].getAllElements(list, false);
            this.regions[3].getAllElements(list, false);
        }
        if (!firstCall) {
            int length = this.nodes.size();
            for (int i = 0; i < length; ++i) {
                list.add(this.nodes.get((int)i).element);
            }
        }
        return list;
    }

    public void getAllZones(ArrayList<QuadRectangle> list) {
        list.add(this.zone);
        if (this.regions != null) {
            this.regions[0].getAllZones(list);
            this.regions[1].getAllZones(list);
            this.regions[2].getAllZones(list);
            this.regions[3].getAllZones(list);
        }
    }

    public void getAllLeafNodeUniqueId(HashSet<Integer> uniqueIdList) {
        if (this.regions != null) {
            this.regions[0].getAllLeafNodeUniqueId(uniqueIdList);
            this.regions[1].getAllLeafNodeUniqueId(uniqueIdList);
            this.regions[2].getAllLeafNodeUniqueId(uniqueIdList);
            this.regions[3].getAllLeafNodeUniqueId(uniqueIdList);
        } else {
            uniqueIdList.add(this.zone.hashCode());
        }
    }

    public int getTotalNumLeafNode() {
        if (this.regions != null) {
            return this.regions[0].getTotalNumLeafNode() + this.regions[1].getTotalNumLeafNode() + this.regions[2].getTotalNumLeafNode() + this.regions[3].getTotalNumLeafNode();
        }
        return 1;
    }

    public QuadRectangle getZone(int x, int y) throws ArrayIndexOutOfBoundsException {
        int region = this.findRegion(x, y);
        if (region != -1) {
            return this.regions[region].getZone(x, y);
        }
        if (this.zone.contains(x, y)) {
            return this.zone;
        }
        throw new ArrayIndexOutOfBoundsException("[Babylon][StandardQuadTree] this pixel is out of the quad tree boundary.");
    }

    public QuadRectangle getParentZone(int x, int y, int minLevel) throws Exception {
        int region = this.findRegion(x, y);
        if (this.level < minLevel) {
            if (region == -1) {
                assert (this.regions == null);
                if (this.zone.contains(x, y)) {
                    throw new Exception("[Babylon][StandardQuadTree][getParentZone] this leaf node doesn't have enough depth. Please check ForceGrowUp. Expected: " + minLevel + " Actual: " + this.level + ". Query point: " + x + " " + y + ". Tree statistics, total leaf nodes: " + this.getTotalNumLeafNode());
                }
                throw new Exception("[Babylon][StandardQuadTree][getParentZone] this pixel is out of the quad tree boundary.");
            }
            return this.regions[region].getParentZone(x, y, minLevel);
        }
        if (this.zone.contains(x, y)) {
            return this.zone;
        }
        throw new Exception("[Babylon][StandardQuadTree][getParentZone] this pixel is out of the quad tree boundary.");
    }

    public void getZone(ArrayList<QuadRectangle> matchedPartitions, QuadRectangle r) {
        if (this.regions == null) {
            matchedPartitions.add(this.zone);
            return;
        }
        if (this.regions != null) {
            if (!this.disjoint(this.regions[0].getZone().getEnvelope(), r.getEnvelope())) {
                this.regions[0].getZone(matchedPartitions, r);
            }
            if (!this.disjoint(this.regions[1].getZone().getEnvelope(), r.getEnvelope())) {
                this.regions[1].getZone(matchedPartitions, r);
            }
            if (!this.disjoint(this.regions[2].getZone().getEnvelope(), r.getEnvelope())) {
                this.regions[2].getZone(matchedPartitions, r);
            }
            if (!this.disjoint(this.regions[3].getZone().getEnvelope(), r.getEnvelope())) {
                this.regions[3].getZone(matchedPartitions, r);
            }
        }
    }

    public boolean disjoint(Envelope r1, Envelope r2) {
        return !r1.intersects(r2) && !r1.covers(r2) && !r2.covers(r1);
    }

    public HashMap<Integer, Integer> getSeriaIdMapping(HashSet<Integer> uniqueIdList) {
        int accumulator = 0;
        HashMap<Integer, Integer> idMapping = new HashMap<Integer, Integer>();
        for (int curId : uniqueIdList) {
            idMapping.put(curId, accumulator);
            ++accumulator;
        }
        return idMapping;
    }

    public void decidePartitionSerialId(HashMap<Integer, Integer> serialIdMapping) {
        if (this.regions == null) {
            this.serialId = serialIdMapping.get(this.zone.hashCode());
            this.zone.partitionId = this.serialId;
            return;
        }
        this.regions[0].decidePartitionSerialId(serialIdMapping);
        this.regions[1].decidePartitionSerialId(serialIdMapping);
        this.regions[2].decidePartitionSerialId(serialIdMapping);
        this.regions[3].decidePartitionSerialId(serialIdMapping);
    }
}

