/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialRDD;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.storage.StorageLevel;
import org.datasyslab.geospark.enums.GridType;
import org.datasyslab.geospark.enums.IndexType;
import org.datasyslab.geospark.spatialPartitioning.EqualPartitioning;
import org.datasyslab.geospark.spatialPartitioning.HilbertPartitioning;
import org.datasyslab.geospark.spatialPartitioning.PartitionJudgement;
import org.datasyslab.geospark.spatialPartitioning.QuadtreePartitioning;
import org.datasyslab.geospark.spatialPartitioning.RtreePartitioning;
import org.datasyslab.geospark.spatialPartitioning.SpatialPartitioner;
import org.datasyslab.geospark.spatialPartitioning.VoronoiPartitioning;
import org.datasyslab.geospark.spatialPartitioning.quadtree.StandardQuadTree;
import org.datasyslab.geospark.spatialRDD.RectangleRDD;
import org.datasyslab.geospark.utils.RDDSampleUtils;
import org.datasyslab.geospark.utils.XMaxComparator;
import org.datasyslab.geospark.utils.XMinComparator;
import org.datasyslab.geospark.utils.YMaxComparator;
import org.datasyslab.geospark.utils.YMinComparator;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.wololo.geojson.Feature;
import org.wololo.jts2geojson.GeoJSONWriter;
import scala.Tuple2;

public abstract class SpatialRDD
implements Serializable {
    static final Logger logger = Logger.getLogger(SpatialRDD.class);
    public long approximateTotalCount = -1L;
    public Envelope boundaryEnvelope = null;
    public JavaRDD<Object> spatialPartitionedRDD;
    public JavaRDD<SpatialIndex> indexedRDD;
    public JavaRDD<Object> indexedRawRDD;
    public JavaRDD<Object> rawSpatialRDD;
    public List<Envelope> grids;
    public StandardQuadTree partitionTree;
    protected boolean CRStransformation = false;
    protected String sourceEpsgCode = "";
    protected String targetEpgsgCode = "";

    protected boolean CRSTransform(String sourceEpsgCRSCode, String targetEpsgCRSCode) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode(sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode(targetEpsgCRSCode);
            final MathTransform transform = CRS.findMathTransform(sourceCRS, targetCRS, false);
            this.CRStransformation = true;
            this.sourceEpsgCode = sourceEpsgCRSCode;
            this.targetEpgsgCode = targetEpsgCRSCode;
            this.rawSpatialRDD = this.rawSpatialRDD.map((Function)new Function<Object, Object>(){

                public Object call(Object originalObject) throws Exception {
                    return JTS.transform((Geometry)originalObject, transform);
                }
            });
            return true;
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean spatialPartitioning(GridType gridType) throws Exception {
        JavaPairRDD spatialNumberingRDD;
        int numPartitions = this.rawSpatialRDD.rdd().partitions().length;
        if (this.boundaryEnvelope == null) {
            throw new Exception("[AbstractSpatialRDD][spatialPartitioning] SpatialRDD boundary is null. Please call analyze() first.");
        }
        if (this.approximateTotalCount == -1L) {
            throw new Exception("[AbstractSpatialRDD][spatialPartitioning] SpatialRDD total count is unkown. Please call analyze() first.");
        }
        int sampleNumberOfRecords = RDDSampleUtils.getSampleNumbers(numPartitions, this.approximateTotalCount);
        ArrayList objectSampleList = new ArrayList(this.rawSpatialRDD.takeSample(false, sampleNumberOfRecords));
        if (gridType == GridType.EQUALGRID) {
            EqualPartitioning EqualPartitioning2 = new EqualPartitioning(this.boundaryEnvelope, numPartitions);
            this.grids = EqualPartitioning2.getGrids();
        } else if (gridType == GridType.HILBERT) {
            HilbertPartitioning hilbertPartitioning = new HilbertPartitioning(objectSampleList, this.boundaryEnvelope, numPartitions);
            this.grids = hilbertPartitioning.getGrids();
        } else if (gridType == GridType.RTREE) {
            RtreePartitioning rtreePartitioning = new RtreePartitioning(objectSampleList, this.boundaryEnvelope, numPartitions);
            this.grids = rtreePartitioning.getGrids();
        } else if (gridType == GridType.VORONOI) {
            VoronoiPartitioning voronoiPartitioning = new VoronoiPartitioning(objectSampleList, this.boundaryEnvelope, numPartitions);
            this.grids = voronoiPartitioning.getGrids();
        } else if (gridType == GridType.QUADTREE) {
            QuadtreePartitioning quadtreePartitioning = new QuadtreePartitioning(objectSampleList, this.boundaryEnvelope, numPartitions);
            this.partitionTree = quadtreePartitioning.getPartitionTree();
        } else {
            throw new Exception("[AbstractSpatialRDD][spatialPartitioning] Unsupported spatial partitioning method.");
        }
        if (gridType == GridType.QUADTREE) {
            spatialNumberingRDD = this.rawSpatialRDD.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Object, Integer, Object>(){

                public Iterator<Tuple2<Integer, Object>> call(Object spatialObject) throws Exception {
                    return PartitionJudgement.getPartitionID(SpatialRDD.this.partitionTree, spatialObject);
                }
            });
            this.spatialPartitionedRDD = spatialNumberingRDD.partitionBy((Partitioner)new SpatialPartitioner(this.partitionTree.getTotalNumLeafNode())).mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Tuple2<Integer, Object>>, Object>(){

                public Iterator<Object> call(Iterator<Tuple2<Integer, Object>> tuple2Iterator) throws Exception {
                    ArrayList<Object> result = new ArrayList<Object>();
                    while (tuple2Iterator.hasNext()) {
                        result.add(tuple2Iterator.next()._2());
                    }
                    return result.iterator();
                }
            }, true);
        } else {
            spatialNumberingRDD = this.rawSpatialRDD.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Object, Integer, Object>(){

                public Iterator<Tuple2<Integer, Object>> call(Object spatialObject) throws Exception {
                    return PartitionJudgement.getPartitionID(SpatialRDD.this.grids, spatialObject);
                }
            });
            this.spatialPartitionedRDD = spatialNumberingRDD.partitionBy((Partitioner)new SpatialPartitioner(this.grids.size())).mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Tuple2<Integer, Object>>, Object>(){

                public Iterator<Object> call(Iterator<Tuple2<Integer, Object>> tuple2Iterator) throws Exception {
                    ArrayList<Object> result = new ArrayList<Object>();
                    while (tuple2Iterator.hasNext()) {
                        result.add(tuple2Iterator.next()._2());
                    }
                    return result.iterator();
                }
            }, true);
        }
        JavaRDD partitionedResult = this.spatialPartitionedRDD.mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Object>, Integer>(){

            public Iterator<Integer> call(Iterator<Object> objectIterator) throws Exception {
                ArrayList<Integer> counts = new ArrayList<Integer>();
                Integer count = 0;
                while (objectIterator.hasNext()) {
                    Object testObject = objectIterator.next();
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                counts.add(count);
                return counts.iterator();
            }
        }, true);
        return true;
    }

    public boolean spatialPartitioning(final List<Envelope> otherGrids) throws Exception {
        JavaPairRDD spatialNumberingRDD = this.rawSpatialRDD.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Object, Integer, Object>(){

            public Iterator<Tuple2<Integer, Object>> call(Object spatialObject) throws Exception {
                return PartitionJudgement.getPartitionID(otherGrids, spatialObject);
            }
        });
        this.grids = otherGrids;
        this.spatialPartitionedRDD = spatialNumberingRDD.partitionBy((Partitioner)new SpatialPartitioner(this.grids.size())).mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Tuple2<Integer, Object>>, Object>(){

            public Iterator<Object> call(Iterator<Tuple2<Integer, Object>> tuple2Iterator) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                while (tuple2Iterator.hasNext()) {
                    result.add(tuple2Iterator.next()._2());
                }
                return result.iterator();
            }
        }, true);
        JavaRDD partitionedResult = this.spatialPartitionedRDD.mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Object>, Integer>(){

            public Iterator<Integer> call(Iterator<Object> objectIterator) throws Exception {
                ArrayList<Integer> counts = new ArrayList<Integer>();
                Integer count = 0;
                while (objectIterator.hasNext()) {
                    Object testObject = objectIterator.next();
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                counts.add(count);
                return counts.iterator();
            }
        }, true);
        return true;
    }

    public boolean spatialPartitioning(final StandardQuadTree partitionTree) throws Exception {
        this.spatialPartitionedRDD = this.rawSpatialRDD.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Object, Integer, Object>(){

            public Iterator<Tuple2<Integer, Object>> call(Object spatialObject) throws Exception {
                return PartitionJudgement.getPartitionID(partitionTree, spatialObject);
            }
        }).partitionBy((Partitioner)new SpatialPartitioner(partitionTree.getTotalNumLeafNode())).mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Tuple2<Integer, Object>>, Object>(){

            public Iterator<Object> call(Iterator<Tuple2<Integer, Object>> tuple2Iterator) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                while (tuple2Iterator.hasNext()) {
                    result.add(tuple2Iterator.next()._2());
                }
                return result.iterator();
            }
        }, true);
        this.partitionTree = partitionTree;
        return true;
    }

    public long countWithoutDuplicates() {
        List collectedResult = this.rawSpatialRDD.collect();
        HashSet resultWithoutDuplicates = new HashSet();
        for (int i = 0; i < collectedResult.size(); ++i) {
            resultWithoutDuplicates.add(collectedResult.get(i));
        }
        return resultWithoutDuplicates.size();
    }

    public long countWithoutDuplicatesSPRDD() {
        JavaRDD<Object> cleanedRDD = this.spatialPartitionedRDD;
        List collectedResult = cleanedRDD.collect();
        HashSet resultWithoutDuplicates = new HashSet();
        for (int i = 0; i < collectedResult.size(); ++i) {
            resultWithoutDuplicates.add(collectedResult.get(i));
        }
        return resultWithoutDuplicates.size();
    }

    public void buildIndex(final IndexType indexType, boolean buildIndexOnSpatialPartitionedRDD) throws Exception {
        if (!buildIndexOnSpatialPartitionedRDD) {
            this.indexedRawRDD = this.rawSpatialRDD.mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Object>, Object>(){

                public Iterator<Object> call(Iterator<Object> spatialObjects) throws Exception {
                    if (indexType == IndexType.RTREE) {
                        STRtree rt = new STRtree();
                        while (spatialObjects.hasNext()) {
                            Geometry spatialObject = (Geometry)spatialObjects.next();
                            rt.insert(spatialObject.getEnvelopeInternal(), (Object)spatialObject);
                        }
                        HashSet<STRtree> result = new HashSet<STRtree>();
                        rt.query(new Envelope(0.0, 0.0, 0.0, 0.0));
                        result.add(rt);
                        return result.iterator();
                    }
                    Quadtree rt = new Quadtree();
                    while (spatialObjects.hasNext()) {
                        Geometry spatialObject = (Geometry)spatialObjects.next();
                        rt.insert(spatialObject.getEnvelopeInternal(), spatialObject);
                    }
                    HashSet<Quadtree> result = new HashSet<Quadtree>();
                    rt.query(new Envelope(0.0, 0.0, 0.0, 0.0));
                    result.add(rt);
                    return result.iterator();
                }
            });
        } else {
            if (this.spatialPartitionedRDD == null) {
                throw new Exception("[AbstractSpatialRDD][buildIndex] spatialPartitionedRDD is null. Please do spatial partitioning before build index.");
            }
            this.indexedRDD = this.spatialPartitionedRDD.mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Object>, SpatialIndex>(){

                public Iterator<SpatialIndex> call(Iterator<Object> objectIterator) throws Exception {
                    if (indexType == IndexType.RTREE) {
                        STRtree rt = new STRtree();
                        while (objectIterator.hasNext()) {
                            Geometry spatialObject = (Geometry)objectIterator.next();
                            rt.insert(spatialObject.getEnvelopeInternal(), (Object)spatialObject);
                        }
                        HashSet<STRtree> result = new HashSet<STRtree>();
                        rt.query(new Envelope(0.0, 0.0, 0.0, 0.0));
                        result.add(rt);
                        return result.iterator();
                    }
                    Quadtree rt = new Quadtree();
                    while (objectIterator.hasNext()) {
                        Geometry spatialObject;
                        Geometry castedSpatialObject = spatialObject = (Geometry)objectIterator.next();
                        rt.insert(castedSpatialObject.getEnvelopeInternal(), castedSpatialObject);
                    }
                    HashSet<Quadtree> result = new HashSet<Quadtree>();
                    rt.query(new Envelope(0.0, 0.0, 0.0, 0.0));
                    result.add(rt);
                    return result.iterator();
                }
            });
        }
    }

    public Envelope boundary() {
        Object minXEnvelope = this.rawSpatialRDD.min((Comparator)new XMinComparator());
        Object minYEnvelope = this.rawSpatialRDD.min((Comparator)new YMinComparator());
        Object maxXEnvelope = this.rawSpatialRDD.max((Comparator)new XMaxComparator());
        Object maxYEnvelope = this.rawSpatialRDD.max((Comparator)new YMaxComparator());
        Double[] boundary = new Double[]{((Geometry)minXEnvelope).getEnvelopeInternal().getMinX(), ((Geometry)minYEnvelope).getEnvelopeInternal().getMinY(), ((Geometry)maxXEnvelope).getEnvelopeInternal().getMaxX(), ((Geometry)maxYEnvelope).getEnvelopeInternal().getMaxY()};
        this.boundaryEnvelope = new Envelope(boundary[0], boundary[2], boundary[1], boundary[3]);
        return this.boundaryEnvelope;
    }

    public JavaRDD<Object> getRawSpatialRDD() {
        return this.rawSpatialRDD;
    }

    public void setRawSpatialRDD(JavaRDD<Object> rawSpatialRDD) {
        this.rawSpatialRDD = rawSpatialRDD;
    }

    public boolean analyze(StorageLevel newLevel) {
        this.rawSpatialRDD.persist(newLevel);
        this.boundary();
        this.approximateTotalCount = this.rawSpatialRDD.count();
        return true;
    }

    public boolean analyze() {
        this.boundary();
        this.approximateTotalCount = this.rawSpatialRDD.count();
        return true;
    }

    public boolean analyze(Envelope datasetBoundary, Integer approximateTotalCount) {
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = this.rawSpatialRDD.count();
        return true;
    }

    public void saveAsGeoJSON(String outputLocation) {
        this.rawSpatialRDD.mapPartitions((FlatMapFunction)new FlatMapFunction<Iterator<Object>, String>(){

            public Iterator<String> call(Iterator<Object> iterator) throws Exception {
                ArrayList<String> result = new ArrayList<String>();
                GeoJSONWriter writer = new GeoJSONWriter();
                while (iterator.hasNext()) {
                    Feature jsonFeature;
                    Geometry spatialObject = (Geometry)iterator.next();
                    if (spatialObject.getUserData() != null) {
                        HashMap<String, Object> userData = new HashMap<String, Object>();
                        userData.put("UserData", spatialObject.getUserData());
                        jsonFeature = new Feature(writer.write(spatialObject), userData);
                    } else {
                        jsonFeature = new Feature(writer.write(spatialObject), null);
                    }
                    String jsonstring = jsonFeature.toString();
                    result.add(jsonstring);
                }
                return result.iterator();
            }
        }).saveAsTextFile(outputLocation);
    }

    @Deprecated
    public RectangleRDD MinimumBoundingRectangle() {
        JavaRDD rectangleRDD = this.rawSpatialRDD.map((Function)new Function<Object, Polygon>(){

            public Polygon call(Object spatialObject) {
                Coordinate[] coordinates = new Coordinate[5];
                GeometryFactory fact = new GeometryFactory();
                Double x1 = ((Geometry)spatialObject).getEnvelopeInternal().getMinX();
                Double x2 = ((Geometry)spatialObject).getEnvelopeInternal().getMaxX();
                Double y1 = ((Geometry)spatialObject).getEnvelopeInternal().getMinY();
                Double y2 = ((Geometry)spatialObject).getEnvelopeInternal().getMaxY();
                coordinates[0] = new Coordinate(x1, y1);
                coordinates[1] = new Coordinate(x1, y2);
                coordinates[2] = new Coordinate(x2, y2);
                coordinates[3] = new Coordinate(x2, y1);
                coordinates[4] = coordinates[0];
                LinearRing linear = fact.createLinearRing(coordinates);
                Polygon polygonObject = new Polygon(linear, null, fact);
                return polygonObject;
            }
        });
        return new RectangleRDD((JavaRDD<Polygon>)rectangleRDD);
    }

    public boolean getCRStransformation() {
        return this.CRStransformation;
    }

    public String getSourceEpsgCode() {
        return this.sourceEpsgCode;
    }

    public String getTargetEpgsgCode() {
        return this.targetEpgsgCode;
    }
}

