/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.utils;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CRSTransformation {
    public static Point Transform(String sourceEpsgCRSCode, String targetEpsgCRSCode, Point sourceObject) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode(sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode(targetEpsgCRSCode);
            MathTransform transform = CRS.findMathTransform(sourceCRS, targetCRS, false);
            return (Point)JTS.transform(sourceObject, transform);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Polygon Transform(String sourceEpsgCRSCode, String targetEpsgCRSCode, Polygon sourceObject) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode(sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode(targetEpsgCRSCode);
            MathTransform transform = CRS.findMathTransform(sourceCRS, targetCRS, false);
            return (Polygon)JTS.transform(sourceObject, transform);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Envelope Transform(String sourceEpsgCRSCode, String targetEpsgCRSCode, Envelope sourceObject) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode(sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode(targetEpsgCRSCode);
            MathTransform transform = CRS.findMathTransform(sourceCRS, targetCRS, false);
            return JTS.transform(sourceObject, transform);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformException e) {
            e.printStackTrace();
            return null;
        }
    }
}

