/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.Filters;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;

public class FidFilterImpl
extends AbstractFilter
implements Id {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    private Set<Identifier> fids = new HashSet<Identifier>();
    private Set<String> ids = new HashSet<String>();

    protected FidFilterImpl() {
    }

    protected FidFilterImpl(String initialFid) {
        this.addFid(initialFid);
    }

    protected FidFilterImpl(Set fids) {
        for (Object next : fids) {
            if (next instanceof Identifier) continue;
            throw new ClassCastException("Fids must implement Identifier, " + next.getClass() + " does not");
        }
        this.fids = fids;
        for (Identifier identifier : this.fids) {
            this.ids.add(identifier.getID().toString());
        }
    }

    public final String[] getFids() {
        return this.fids().toArray(new String[0]);
    }

    public Set getIDs() {
        return this.getFidsSet();
    }

    @Override
    public Set<Identifier> getIdentifiers() {
        return this.fids;
    }

    public void setIDs(Set ids) {
        this.fids = new HashSet<Identifier>();
        this.addAllFids(ids);
    }

    public Set<String> getFidsSet() {
        return this.fids();
    }

    private Set<String> fids() {
        return new HashSet<String>(this.ids);
    }

    public final void addFid(String fid) {
        LOGGER.finest("got fid: " + fid);
        this.fids.add(new FeatureIdImpl(fid));
        this.ids.add(fid);
    }

    public void addAllFids(Collection fidsToAdd) {
        if (fidsToAdd == null) {
            return;
        }
        for (String fid : fidsToAdd) {
            this.addFid(fid);
        }
    }

    public final void removeFid(String fid) {
        if (fid == null) {
            return;
        }
        Iterator<Identifier> f = this.fids.iterator();
        while (f.hasNext()) {
            Identifier featureId = f.next();
            if (!fid.equals(featureId.getID().toString())) continue;
            f.remove();
            this.ids.remove(fid);
        }
    }

    public void removeAllFids(Collection fidsToRemove) {
        if (fidsToRemove == null) {
            return;
        }
        for (String fid : fidsToRemove) {
            this.removeFid(fid);
        }
    }

    @Override
    public boolean evaluate(Object feature) {
        if (feature == null) {
            return false;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String evaluate = ff.property("@id").evaluate(feature, String.class);
        if (evaluate == null) {
            return false;
        }
        return this.ids.contains(evaluate);
    }

    public String toString() {
        StringBuffer fidFilter = new StringBuffer();
        Iterator<Identifier> fidIterator = this.fids.iterator();
        while (fidIterator.hasNext()) {
            fidFilter.append(((Object)fidIterator.next()).toString());
            if (!fidIterator.hasNext()) continue;
            fidFilter.append(", ");
        }
        return "[ " + fidFilter.toString() + " ]";
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    public boolean equals(Object filter) {
        LOGGER.finest("condition: " + filter);
        if (filter != null && filter.getClass() == this.getClass()) {
            FidFilterImpl other = (FidFilterImpl)filter;
            short filterType = Filters.getFilterType(other);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("condition: " + filterType);
            }
            if (filterType == 22) {
                return this.fids.equals(other.fids);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.fids.hashCode();
    }
}

