/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.NoSuchAuthorityCodeException;

final class Code {
    public final String authority;
    public final int code;
    public final double longitude;
    public final double latitude;
    final Class type;

    public Code(String text, Class type) throws NoSuchAuthorityCodeException {
        String authority = "AUTO";
        int code = 0;
        int unit = 9001;
        double longitude = Double.NaN;
        double latitude = Double.NaN;
        String[] parts = text.startsWith("AUTO") ? text.replaceAll("AUTO(2)?\\s*:", "").split("\\s*,\\s*") : text.split("\\s*,\\s*");
        if (parts.length < 3) {
            throw Code.noSuchAuthorityCode(type, text);
        }
        try {
            if (parts.length < 4) {
                code = Integer.parseInt(parts[0]);
                longitude = Double.parseDouble(parts[1]);
                latitude = Double.parseDouble(parts[2]);
            } else {
                code = Integer.parseInt(parts[0]);
                unit = Integer.parseInt(parts[1]);
                longitude = Double.parseDouble(parts[2]);
                latitude = Double.parseDouble(parts[3]);
            }
        }
        catch (NumberFormatException exception) {
            NoSuchAuthorityCodeException e = Code.noSuchAuthorityCode(type, text);
            e.initCause(exception);
            throw e;
        }
        if (!(longitude >= -180.0 && longitude <= 180.0 && latitude >= -90.0 && latitude <= 90.0)) {
            throw Code.noSuchAuthorityCode(type, text);
        }
        this.authority = authority;
        this.code = code;
        this.longitude = longitude;
        this.latitude = latitude;
        this.type = type;
    }

    private static NoSuchAuthorityCodeException noSuchAuthorityCode(Class type, String code) {
        String authority = "AUTO";
        return new NoSuchAuthorityCodeException(Errors.format(138, code, "AUTO", type), "AUTO", code);
    }

    public String toString() {
        return this.authority + ':' + this.code + ',' + this.longitude + ',' + this.latitude;
    }
}

