/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

class UomRescaleHelper {
    private double mapScale = 1.0;
    private FilterFactory ff;
    private boolean rescaleRealWorldUnits;

    public UomRescaleHelper(FilterFactory ff, double mapScale, boolean rescaleRealWorldUnits) {
        this.rescaleRealWorldUnits = rescaleRealWorldUnits;
        this.ff = ff;
        this.mapScale = mapScale;
    }

    protected double computeRescaleMultiplier(Unit<Length> uom) {
        if (uom == null || uom.equals(NonSI.PIXEL)) {
            return 1.0;
        }
        if (uom == SI.METER) {
            return this.mapScale;
        }
        UnitConverter converter = uom.getConverterTo(SI.METER);
        return converter.convert(this.mapScale);
    }

    protected Expression rescale(Expression unscaled, Unit<Length> uom) {
        if (unscaled == null || unscaled.equals(Expression.NIL)) {
            return unscaled;
        }
        if (unscaled instanceof Literal) {
            String value = unscaled.evaluate(null, String.class);
            if (value == null) {
                throw new IllegalArgumentException("Invalid empty measure '', was expecting a number, eventually followed by px, m or ft");
            }
            if (value.endsWith("px")) {
                value = value.substring(0, value.length() - 2);
                return this.ff.literal(Converters.convert(value, Double.class));
            }
            if (value.endsWith("ft")) {
                value = value.substring(0, value.length() - 2);
                uom = NonSI.FOOT;
            } else if (value.endsWith("m")) {
                value = value.substring(0, value.length() - 1);
                uom = SI.METER;
            }
            Double measure = Converters.convert(value, Double.class);
            if (measure != null) {
                double rescaled = this.rescale(measure, uom);
                return this.ff.literal(rescaled);
            }
            throw new IllegalArgumentException("Invalid measure '" + value + "', was expecting a number, eventually followed by px, m or ft");
        }
        double rescaleMultiplier = this.computeRescaleMultiplier(uom);
        return this.ff.multiply(unscaled, this.ff.literal(rescaleMultiplier));
    }

    protected float[] rescale(float[] dashArray, Unit<Length> unitOfMeasure) {
        if (dashArray == null) {
            return null;
        }
        if (unitOfMeasure == null || unitOfMeasure.equals(NonSI.PIXEL)) {
            return dashArray;
        }
        float[] rescaledDashArray = new float[dashArray.length];
        for (int i = 0; i < rescaledDashArray.length; ++i) {
            rescaledDashArray[i] = (float)this.rescale(dashArray[i], unitOfMeasure);
        }
        return rescaledDashArray;
    }

    private double rescale(double unscaled, Unit<Length> uom) {
        return unscaled * this.computeRescaleMultiplier(uom);
    }
}

