/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.mockrunner.mock.web.MockHttpServletResponse;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.gwc.GWC;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;

public class GWCIntegrationTest
extends GeoServerTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GWCIntegrationTest());
    }

    protected void setUpInternal() {
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(false);
    }

    public void testPngIntegration() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/service/wmts?request=GetTile&layer=" + layerId + "&format=image/png&tilematrixset=EPSG:4326&tilematrix=EPSG:4326:0&tilerow=0&tilecol=0");
        GWCIntegrationTest.assertEquals((int)200, (int)sr.getErrorCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)sr.getContentType());
    }

    public void testDirectWMSIntegration() throws Exception {
        GWC gwc = GWC.get();
        gwc.getConfig().setDirectWMSIntegrationEnabled(true);
        String layerName = String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String request = this.buildGetMap(true, layerName, "EPSG:4326", null);
        MockHttpServletResponse response = this.getAsServletResponse(request);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getErrorCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GWCIntegrationTest.assertNull((Object)response.getHeader("geowebcache-tile-index"));
        request = String.valueOf(request) + "&tiled=true";
        response = this.getAsServletResponse(request);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getErrorCode());
        GWCIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GWCIntegrationTest.assertEquals((String)"[0, 0, 0]", (String)response.getHeader("geowebcache-tile-index"));
    }

    private String buildGetMap(boolean directWMSIntegrationEndpoint, String layerName, String gridsetId, String styles) {
        GWC gwc = GWC.get();
        TileLayer tileLayer = gwc.getTileLayerByName(layerName);
        GridSubset gridSubset = tileLayer.getGridSubset(gridsetId);
        long[] coverage = gridSubset.getCoverage(0);
        long[] tileIndex = new long[]{coverage[0], coverage[1], coverage[4]};
        BoundingBox bounds = gridSubset.boundsFromIndex(tileIndex);
        String endpoint = directWMSIntegrationEndpoint ? "wms" : "gwc/service/wms";
        StringBuilder sb = new StringBuilder(endpoint);
        sb.append("?service=WMS&request=GetMap&version=1.1.1&format=image/png");
        sb.append("&layers=").append(layerName);
        sb.append("&srs=").append(gridSubset.getSRS());
        sb.append("&width=").append(gridSubset.getGridSet().getTileWidth());
        sb.append("&height=").append(gridSubset.getGridSet().getTileHeight());
        sb.append("&styles=");
        if (styles != null) {
            sb.append(styles);
        }
        sb.append("&bbox=").append(bounds.toString());
        return sb.toString();
    }

    public void testReloadConfiguration() throws Exception {
        String path = "/gwc/rest/reload";
        String content = "reload_configuration=1";
        String contentType = "application/x-www-form-urlencoded";
        MockHttpServletResponse response = this.postAsServletResponse(path, content, contentType);
        GWCIntegrationTest.assertEquals((int)200, (int)response.getStatusCode());
    }
}

