/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.Serializable;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;

public class NamespaceWorkspaceConsistencyListener
implements CatalogListener {
    Catalog catalog;
    boolean editing = false;

    public NamespaceWorkspaceConsistencyListener(Catalog catalog) {
        this.catalog = catalog;
        catalog.addListener(this);
    }

    public synchronized void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        WorkspaceInfo newDefault;
        NamespaceInfo ns;
        List<String> properties = event.getPropertyNames();
        if (event.getSource() instanceof NamespaceInfo && !this.editing && properties.contains("prefix")) {
            int prefixIdx = properties.indexOf("prefix");
            String oldPrefix = (String)event.getOldValues().get(prefixIdx);
            String newPrefix = (String)event.getNewValues().get(prefixIdx);
            WorkspaceInfo ws = this.catalog.getWorkspaceByName(oldPrefix);
            if (ws != null) {
                try {
                    this.editing = true;
                    ws.setName(newPrefix);
                    this.catalog.save(ws);
                }
                finally {
                    this.editing = false;
                }
            }
        } else if (event.getSource() instanceof Catalog && properties.contains("defaultNamespace") && !this.editing) {
            NamespaceInfo newDefault2 = (NamespaceInfo)event.getNewValues().get(properties.indexOf("defaultNamespace"));
            WorkspaceInfo ws = this.catalog.getWorkspaceByName(newDefault2.getPrefix());
            if (ws != null && !this.catalog.getDefaultWorkspace().equals(ws)) {
                try {
                    this.editing = true;
                    this.catalog.setDefaultWorkspace(ws);
                }
                finally {
                    this.editing = false;
                }
            }
        } else if (event.getSource() instanceof WorkspaceInfo && !this.editing && properties.contains("name")) {
            WorkspaceInfo ws = (WorkspaceInfo)event.getSource();
            int nameIdx = properties.indexOf("name");
            String oldName = (String)event.getOldValues().get(nameIdx);
            String newName = (String)event.getNewValues().get(nameIdx);
            NamespaceInfo ns2 = this.catalog.getNamespaceByPrefix(oldName);
            if (ns2 != null) {
                try {
                    this.editing = true;
                    ns2.setPrefix(newName);
                    this.catalog.save(ns2);
                }
                finally {
                    this.editing = false;
                }
            }
        } else if (event.getSource() instanceof Catalog && properties.contains("defaultWorkspace") && !this.editing && (ns = this.catalog.getNamespaceByPrefix((newDefault = (WorkspaceInfo)event.getNewValues().get(properties.indexOf("defaultWorkspace"))).getName())) != null && !this.catalog.getDefaultNamespace().equals(ns)) {
            try {
                this.editing = true;
                this.catalog.setDefaultNamespace(ns);
            }
            finally {
                this.editing = false;
            }
        }
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) {
        if (event.getSource() instanceof NamespaceInfo) {
            List<DataStoreInfo> stores;
            NamespaceInfo ns = (NamespaceInfo)event.getSource();
            String namespaceURI = ns.getURI();
            WorkspaceInfo ws = this.catalog.getWorkspaceByName(ns.getPrefix());
            if (ws != null && (stores = this.catalog.getDataStoresByWorkspace(ws)).size() > 0) {
                for (DataStoreInfo store : stores) {
                    String oldURI = (String)((Object)store.getConnectionParameters().get("namespace"));
                    if (oldURI == null || namespaceURI.equals(oldURI)) continue;
                    store.getConnectionParameters().put("namespace", (Serializable)((Object)namespaceURI));
                    this.catalog.save(store);
                }
            }
        }
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
    }

    public void reloaded() {
    }
}

