/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.List;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;

public class ResourcePoolInitializer
implements GeoServerInitializer {
    GeoServer gs;

    public void initialize(GeoServer geoServer) throws Exception {
        this.gs = geoServer;
        int cacheSize = geoServer.getGlobal().getFeatureTypeCacheSize();
        if (cacheSize > 0) {
            this.gs.getCatalog().getResourcePool().setFeatureTypeCacheSize(cacheSize);
        }
        geoServer.addListener(new ConfigurationListenerAdapter(){

            @Override
            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                int i = propertyNames.indexOf("featureTypeCacheSize");
                if (i > -1) {
                    ResourcePoolInitializer.this.gs.getCatalog().getResourcePool().setFeatureTypeCacheSize(i);
                }
            }
        });
    }
}

