/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geotools.util.logging.Logging;

public class LayerInfoImpl
implements LayerInfo {
    static final Logger LOGGER = Logging.getLogger(LayerInfoImpl.class);
    protected String id;
    protected transient String name;
    protected String path;
    protected LayerInfo.Type type;
    protected StyleInfo defaultStyle;
    protected Set styles = new HashSet();
    protected ResourceInfo resource;
    protected LegendInfo legend;
    protected boolean enabled;
    protected MetadataMap metadata = new MetadataMap();
    protected AttributionInfo attribution;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.resource.getName();
    }

    public void setName(String name) {
        LOGGER.log(Level.FINE, "Warning, some code is setting the LayerInfo name, but that will be ignored");
        this.name = name;
        this.resource.setName(name);
    }

    public LayerInfo.Type getType() {
        return this.type;
    }

    public void setType(LayerInfo.Type type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public StyleInfo getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(StyleInfo defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public Set getStyles() {
        return this.styles;
    }

    public void setStyles(Set styles) {
        this.styles = styles;
    }

    public ResourceInfo getResource() {
        return this.resource;
    }

    public void setResource(ResourceInfo resource) {
        this.resource = resource;
    }

    public LegendInfo getLegend() {
        return this.legend;
    }

    public void setLegend(LegendInfo legend) {
        this.legend = legend;
    }

    public AttributionInfo getAttribution() {
        return this.attribution;
    }

    public void setAttribution(AttributionInfo attribution) {
        this.attribution = attribution;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean enabled() {
        ResourceInfo resource = this.getResource();
        boolean resourceEnabled = resource != null && resource.enabled();
        boolean thisEnabled = this.isEnabled();
        return resourceEnabled && thisEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        ResourceInfo resource = this.getResource();
        if (resource != null) {
            resource.setEnabled(enabled);
        }
    }

    public MetadataMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataMap metadata) {
        this.metadata = metadata;
    }

    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultStyle == null ? 0 : this.defaultStyle.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.legend == null ? 0 : this.legend.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.styles == null ? 0 : this.styles.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.attribution == null ? 0 : this.attribution.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerInfo)) {
            return false;
        }
        LayerInfo other = (LayerInfo)obj;
        if (this.defaultStyle == null ? other.getDefaultStyle() != null : !this.defaultStyle.equals(other.getDefaultStyle())) {
            return false;
        }
        if (this.enabled != other.isEnabled()) {
            return false;
        }
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        if (this.legend == null ? other.getLegend() != null : !this.legend.equals(other.getLegend())) {
            return false;
        }
        if (this.path == null ? other.getPath() != null : !this.path.equals(other.getPath())) {
            return false;
        }
        if (this.resource == null ? other.getResource() != null : !this.resource.equals(other.getResource())) {
            return false;
        }
        if (this.styles == null ? other.getStyles() != null : !this.styles.equals(other.getStyles())) {
            return false;
        }
        if (this.type == null ? other.getType() != null : !this.type.equals((Object)other.getType())) {
            return false;
        }
        return !(this.attribution == null ? other.getAttribution() != null : !this.attribution.equals(other.getAttribution()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getName() + ", resource:" + this.resource + ']';
    }
}

