/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ReprojectingFilterVisitor
extends DuplicatingFilterVisitor {
    FeatureType featureType;

    public ReprojectingFilterVisitor(FilterFactory2 factory, FeatureType featureType) {
        super(factory);
        this.featureType = featureType;
    }

    private CoordinateReferenceSystem findPropertyCRS(PropertyName propertyName) {
        AttributeDescriptor at = (AttributeDescriptor)propertyName.evaluate((Object)this.featureType);
        if (at instanceof GeometryDescriptor) {
            GeometryDescriptor gat = (GeometryDescriptor)at;
            return gat.getCoordinateReferenceSystem();
        }
        return null;
    }

    public Object visit(BBOX filter, Object extraData) {
        String srs = filter.getSRS();
        if (srs == null || "".equals(srs.trim())) {
            return super.visit(filter, extraData);
        }
        try {
            CoordinateReferenceSystem crs;
            double minx = filter.getMinX();
            double miny = filter.getMinY();
            double maxx = filter.getMaxX();
            double maxy = filter.getMaxY();
            try {
                crs = CRS.decode((String)srs);
            }
            catch (NoSuchAuthorityCodeException e) {
                crs = CRS.parseWKT((String)srs);
            }
            String propertyName = filter.getPropertyName();
            CoordinateReferenceSystem targetCrs = this.findPropertyCRS(this.ff.property(propertyName));
            if (crs != null && targetCrs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)targetCrs)) {
                ReferencedEnvelope envelope = new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
                envelope = envelope.transform(targetCrs, true);
                minx = envelope.getMinX();
                miny = envelope.getMinY();
                maxx = envelope.getMaxX();
                maxy = envelope.getMaxY();
                srs = targetCrs.getIdentifiers().isEmpty() ? targetCrs.toString() : ((ReferenceIdentifier)targetCrs.getIdentifiers().iterator().next()).toString();
            }
            return this.getFactory(extraData).bbox(propertyName, minx, miny, maxx, maxy, srs);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not decode srs '" + srs + "'", e);
        }
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return new BinaryComparisonTransformer(){

            Object cloneFilter(BinaryComparisonOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((PropertyIsEqualTo)filter, extraData);
            }

            Object cloneFilter(BinaryComparisonOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.equal(ex1, ex2, bso.isMatchingCase());
            }
        }.transform((BinaryComparisonOperator)filter, extraData);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return new BinaryComparisonTransformer(){

            Object cloneFilter(BinaryComparisonOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((PropertyIsNotEqualTo)filter, extraData);
            }

            Object cloneFilter(BinaryComparisonOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.notEqual(ex1, ex2, bso.isMatchingCase());
            }
        }.transform((BinaryComparisonOperator)filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Beyond)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                Beyond filter = (Beyond)bso;
                return ReprojectingFilterVisitor.this.ff.beyond(ex1, ex2, filter.getDistance(), filter.getDistanceUnits());
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Contains)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.contains(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Crosses)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.crosses(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Disjoint)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.disjoint(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((DWithin)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                DWithin filter = (DWithin)bso;
                return ReprojectingFilterVisitor.this.ff.dwithin(ex1, ex2, filter.getDistance(), filter.getDistanceUnits());
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Intersects)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.intersects(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Overlaps)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.overlaps(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Touches)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.touches(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Within)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.within(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Equals)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.ff.equal(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    protected Geometry reproject(Object value, CoordinateReferenceSystem propertyCrs) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Geometry)) {
            throw new IllegalArgumentException("Binary geometry filter, but second expression is not a geometry literal? (it's a " + value.getClass() + ")");
        }
        Geometry geom = (Geometry)value;
        if (geom.getUserData() == null || !(geom.getUserData() instanceof CoordinateReferenceSystem)) {
            return geom;
        }
        try {
            CoordinateReferenceSystem geomCRS = (CoordinateReferenceSystem)geom.getUserData();
            Geometry transformed = JTS.transform((Geometry)geom, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)propertyCrs, (boolean)true));
            transformed.setUserData((Object)propertyCrs);
            return transformed;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not reproject geometry " + value, e);
        }
    }

    Expression reproject(Expression expression, CoordinateReferenceSystem propertyCrs, boolean forceReprojection) {
        if (expression instanceof Function) {
            Function delegate = (Function)expression;
            return new FunctionReprojector(propertyCrs, delegate);
        }
        if (expression instanceof Literal) {
            Object value = ((Literal)expression).getValue();
            return this.ff.literal((Object)this.reproject(value, propertyCrs));
        }
        if (forceReprojection) {
            throw new IllegalArgumentException("Binary geometry filter, but second expression is not a literal or function? (it's a " + expression.getClass() + ")");
        }
        return null;
    }

    private abstract class BinaryComparisonTransformer {
        private BinaryComparisonTransformer() {
        }

        Object transform(BinaryComparisonOperator filter, Object extraData) {
            Expression other;
            PropertyName name;
            if (filter.getExpression1() instanceof PropertyName) {
                name = (PropertyName)filter.getExpression1();
                other = filter.getExpression2();
            } else if (filter.getExpression2() instanceof PropertyName) {
                name = (PropertyName)filter.getExpression2();
                other = filter.getExpression1();
            } else {
                return this.cloneFilter(filter, extraData);
            }
            CoordinateReferenceSystem propertyCrs = ReprojectingFilterVisitor.this.findPropertyCRS(name);
            if (propertyCrs == null) {
                return this.cloneFilter(filter, extraData);
            }
            Expression ex1 = (Expression)name.accept((ExpressionVisitor)ReprojectingFilterVisitor.this, extraData);
            Expression ex2 = ReprojectingFilterVisitor.this.reproject(other, propertyCrs, false);
            if (ex2 == null) {
                ex2 = (Expression)other.accept((ExpressionVisitor)ReprojectingFilterVisitor.this, extraData);
            }
            return this.cloneFilter(filter, extraData, ex1, ex2);
        }

        abstract Object cloneFilter(BinaryComparisonOperator var1, Object var2);

        abstract Object cloneFilter(BinaryComparisonOperator var1, Object var2, Expression var3, Expression var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FunctionReprojector
    implements Function {
        private final CoordinateReferenceSystem propertyCrs;
        private final Function delegate;

        protected FunctionReprojector(CoordinateReferenceSystem propertyCrs, Function delegate) {
            this.propertyCrs = propertyCrs;
            this.delegate = delegate;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public List<Expression> getParameters() {
            return this.delegate.getParameters();
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return this.delegate.accept(visitor, extraData);
        }

        public Object evaluate(Object object) {
            Object value = this.delegate.evaluate(object);
            return ReprojectingFilterVisitor.this.reproject(value, this.propertyCrs);
        }

        public <T> T evaluate(Object object, Class<T> context) {
            Object value = this.delegate.evaluate(object, context);
            return (T)ReprojectingFilterVisitor.this.reproject(value, this.propertyCrs);
        }

        public Literal getFallbackValue() {
            return null;
        }
    }

    private abstract class GeometryFilterTransformer {
        private GeometryFilterTransformer() {
        }

        Object transform(BinarySpatialOperator filter, Object extraData) {
            if (!(filter.getExpression1() instanceof PropertyName)) {
                throw new IllegalArgumentException("Binary geometry filter, but first expression is not a property name? (it's a " + filter.getExpression1().getClass() + ")");
            }
            CoordinateReferenceSystem propertyCrs = ReprojectingFilterVisitor.this.findPropertyCRS((PropertyName)filter.getExpression1());
            if (propertyCrs == null) {
                return this.cloneFilter(filter, extraData);
            }
            Expression ex1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)ReprojectingFilterVisitor.this, extraData);
            Expression ex2 = ReprojectingFilterVisitor.this.reproject(filter.getExpression2(), propertyCrs, true);
            return this.cloneFilter(filter, extraData, ex1, ex2);
        }

        abstract Object cloneFilter(BinarySpatialOperator var1, Object var2);

        abstract Object cloneFilter(BinarySpatialOperator var1, Object var2, Expression var3, Expression var4);
    }
}

