/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

public class DisabledServiceCheck
implements DispatcherCallback {
    static final Logger LOGGER = Logging.getLogger(DisabledServiceCheck.class);

    public Request init(Request request) {
        return request;
    }

    public Service serviceDispatched(Request request, Service service) {
        block7: {
            Object s = service.getService();
            Method m = null;
            if (s instanceof Proxy) {
                Class<?>[] interfaces = s.getClass().getInterfaces();
                int i = 0;
                while (m == null && i < interfaces.length) {
                    m = OwsUtils.getter(interfaces[i], (String)"serviceInfo", ServiceInfo.class);
                    ++i;
                }
            } else {
                m = OwsUtils.getter(s.getClass(), (String)"serviceInfo", ServiceInfo.class);
            }
            if (m != null) {
                try {
                    ServiceInfo info = (ServiceInfo)m.invoke(s, null);
                    if (!info.isEnabled()) {
                        throw new ServiceException("Service " + info.getName() + " is disabled");
                    }
                    break block7;
                }
                catch (Exception e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            LOGGER.warning("Could not get a ServiceInfo for service " + service.getId() + " thus could not check if the service is enabled");
        }
        return service;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return result;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return response;
    }

    public void finished(Request request) {
    }
}

