/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.security.AbstractAccessRuleDAO;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTAccessRuleDAO
extends AbstractAccessRuleDAO<String> {
    static final Pattern PATTERN;

    static {
        LOGGER = Logging.getLogger(RESTAccessRuleDAO.class);
        PATTERN = Pattern.compile("\\S+;(GET|POST|PUT|DELETE|HEAD)(,(GET|POST|PUT|DELETE|HEAD))*=\\S+(, ?\\S+)*");
    }

    protected RESTAccessRuleDAO(GeoServerDataDirectory dd) throws IOException {
        super(dd, "rest.properties");
    }

    @Override
    protected void loadRules(Properties props) {
        this.rules = new TreeSet();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String rule = String.valueOf(key) + "=" + val;
            if (!PATTERN.matcher(rule).matches()) {
                LOGGER.severe("Ignoring '" + rule + "' not matching " + PATTERN);
                continue;
            }
            rule = rule.replaceAll(";", ":");
            this.rules.add(rule);
        }
    }

    @Override
    protected Properties toProperties() {
        return null;
    }
}

