/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class GeoServerTemplateLoader
implements TemplateLoader {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.template");
    FileTemplateLoader fileTemplateLoader;
    ClassTemplateLoader classTemplateLoader;
    GeoServerDataDirectory dd;
    ResourceInfo resource;
    SimpleFeatureType featureType;
    private String coverageName;
    private Catalog catalog;

    public GeoServerTemplateLoader(Class caller) throws IOException {
        this(caller, (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class));
    }

    public GeoServerTemplateLoader(Class caller, GeoServerResourceLoader rl) throws IOException {
        this.fileTemplateLoader = new FileTemplateLoader(rl.getBaseDirectory());
        this.catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        if (caller != null) {
            this.classTemplateLoader = new ClassTemplateLoader(caller, "");
        }
        this.dd = new GeoServerDataDirectory(rl);
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName(featureType.getName());
        if (ft == null) {
            return;
        }
        this.setFeatureType(ft);
    }

    public void setFeatureType(FeatureTypeInfo ft) {
        this.resource = ft;
    }

    public void setCoverageName(String coverageName) {
        this.coverageName = coverageName;
        CoverageInfo c = this.catalog.getCoverageByName(coverageName);
        if (c == null) {
            return;
        }
        this.setCoverage(c);
    }

    public void setCoverage(CoverageInfo c) {
        this.resource = c;
    }

    public Object findTemplateSource(String path) throws IOException {
        Object source;
        File template = null;
        if (this.resource != null) {
            template = this.dd.findSuppResourceFile(this.resource, path);
            if (template == null) {
                template = this.dd.findSuppStoreFile(this.resource.getStore(), path);
            }
            if (template == null) {
                template = this.dd.findSuppWorkspaceFile(this.resource.getStore().getWorkspace(), path);
            }
            if (template != null) {
                return template;
            }
        }
        if ((template = this.findTemplateSourceLegacy(path)) != null) {
            return template;
        }
        template = (File)this.fileTemplateLoader.findTemplateSource("templates" + File.separator + path);
        if (template != null) {
            return template;
        }
        if (this.classTemplateLoader != null && (source = this.classTemplateLoader.findTemplateSource(path)) != null) {
            return new ClassTemplateSource(path, source);
        }
        return null;
    }

    File findTemplateSourceLegacy(String path) throws IOException {
        File template = null;
        try {
            String dirName;
            String baseDirName;
            if (this.featureType != null) {
                baseDirName = "featureTypes";
                dirName = GeoserverDataDirectory.findFeatureTypeDirName(this.featureType);
            } else if (this.coverageName != null) {
                baseDirName = "coverages";
                dirName = GeoserverDataDirectory.findCoverageDirName(this.coverageName);
            } else {
                baseDirName = "featureTypes";
                dirName = "";
            }
            template = (File)this.fileTemplateLoader.findTemplateSource(String.valueOf(baseDirName) + File.separator + dirName + File.separator + path);
            if (template != null) {
                return template;
            }
            if (this.featureType != null) {
                NamespaceInfo nsInfo = null;
                if (this.featureType.getName().getNamespaceURI() != null) {
                    nsInfo = this.catalog.getNamespaceByURI(this.featureType.getName().getNamespaceURI());
                }
                if (nsInfo != null) {
                    template = (File)this.fileTemplateLoader.findTemplateSource("templates" + File.separator + nsInfo.getPrefix() + File.separator + path);
                }
            }
            if (template != null) {
                return template;
            }
            template = (File)this.fileTemplateLoader.findTemplateSource(String.valueOf(baseDirName) + File.separator + path);
            if (template != null) {
                return template;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public long getLastModified(Object source) {
        if (source instanceof File) {
            return this.fileTemplateLoader.getLastModified(source);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getLastModified(wrapper.source);
    }

    public Reader getReader(Object source, String encoding) throws IOException {
        if (source instanceof File) {
            return this.fileTemplateLoader.getReader(source, encoding);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getReader(wrapper.source, encoding);
    }

    public void closeTemplateSource(Object source) throws IOException {
        if (source instanceof File) {
            this.fileTemplateLoader.closeTemplateSource(source);
        } else {
            ClassTemplateSource wrapper = (ClassTemplateSource)source;
            this.classTemplateLoader.closeTemplateSource(wrapper.source);
            wrapper.path = null;
            wrapper.source = null;
        }
    }

    static class ClassTemplateSource {
        String path;
        Object source;

        public ClassTemplateSource(String path, Object source) {
            this.path = path;
            this.source = source;
        }
    }
}

