/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.feature.DefaultCRSFilterVisitor;
import org.geoserver.feature.ReprojectingFilterVisitor;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.global.GeoServerFeatureLocking;
import org.vfny.geoserver.global.GeoServerFeatureStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerFeatureSource
implements FeatureSource<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    protected FeatureSource<SimpleFeatureType, SimpleFeature> source;
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    protected SimpleFeatureType schema;
    protected Filter definitionQuery = Filter.INCLUDE;
    protected CoordinateReferenceSystem declaredCRS;
    protected ProjectionPolicy srsHandling;

    GeoServerFeatureSource(FeatureSource<SimpleFeatureType, SimpleFeature> source, SimpleFeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling) {
        this.source = source;
        this.schema = schema;
        this.definitionQuery = definitionQuery;
        this.declaredCRS = declaredCRS;
        this.srsHandling = ProjectionPolicy.get(srsHandling);
        if (this.definitionQuery == null) {
            this.definitionQuery = Filter.INCLUDE;
        }
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public static GeoServerFeatureSource create(FeatureSource<SimpleFeatureType, SimpleFeature> featureSource, SimpleFeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling) {
        if (featureSource instanceof FeatureLocking) {
            return new GeoServerFeatureLocking((FeatureLocking<SimpleFeatureType, SimpleFeature>)((FeatureLocking)featureSource), schema, definitionQuery, declaredCRS, srsHandling);
        }
        if (featureSource instanceof FeatureStore) {
            return new GeoServerFeatureStore((FeatureStore<SimpleFeatureType, SimpleFeature>)((FeatureStore)featureSource), schema, definitionQuery, declaredCRS, srsHandling);
        }
        return new GeoServerFeatureSource(featureSource, schema, definitionQuery, declaredCRS, srsHandling);
    }

    protected Query makeDefinitionQuery(Query query, SimpleFeatureType schema) throws IOException {
        if (query == Query.ALL || query.equals(Query.ALL)) {
            return query;
        }
        try {
            String[] propNames = this.extractAllowedAttributes(query, schema);
            Filter filter = query.getFilter();
            filter = this.makeDefinitionFilter(filter);
            DefaultQuery defQuery = new DefaultQuery(query);
            defQuery.setFilter(filter);
            defQuery.setPropertyNames(propNames);
            if (query.getSortBy() != null) {
                defQuery.setSortBy(query.getSortBy());
            }
            return defQuery;
        }
        catch (Exception ex) {
            throw new DataSourceException("Could not restrict the query to the definition criteria: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private String[] extractAllowedAttributes(Query query, SimpleFeatureType schema) {
        String[] propNames = null;
        if (query.retrieveAllProperties()) {
            propNames = new String[schema.getAttributeCount()];
            int i = 0;
            while (i < schema.getAttributeCount()) {
                propNames[i] = schema.getDescriptor(i).getLocalName();
                ++i;
            }
        } else {
            String[] queriedAtts = query.getPropertyNames();
            int queriedAttCount = queriedAtts.length;
            LinkedList<String> allowedAtts = new LinkedList<String>();
            int i = 0;
            while (i < queriedAttCount) {
                if (schema.getDescriptor(queriedAtts[i]) != null) {
                    allowedAtts.add(queriedAtts[i]);
                } else {
                    LOGGER.info("queried a not allowed property: " + queriedAtts[i] + ". Ommitting it from query");
                }
                ++i;
            }
            propNames = allowedAtts.toArray(new String[allowedAtts.size()]);
        }
        return propNames;
    }

    protected Filter makeDefinitionFilter(Filter filter) throws DataSourceException {
        Filter newFilter = filter;
        try {
            if (this.definitionQuery != Filter.INCLUDE) {
                newFilter = this.ff.and(this.definitionQuery, filter);
            }
        }
        catch (Exception ex) {
            throw new DataSourceException("Can't create the definition filter", (Throwable)ex);
        }
        return newFilter;
    }

    public DataStore getDataStore() {
        return (DataStore)this.source.getDataStore();
    }

    public void addFeatureListener(FeatureListener listener) {
        this.source.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.source.removeFeatureListener(listener);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Query query) throws IOException {
        Query reprojected = this.reprojectFilter(query);
        Query newQuery = this.adaptQuery(reprojected, this.schema);
        CoordinateReferenceSystem targetCRS = query.getCoordinateSystemReproject();
        try {
            FeatureCollection fc = this.source.getFeatures(newQuery);
            return this.applyProjectionPolicies(targetCRS, (FeatureCollection<SimpleFeatureType, SimpleFeature>)fc);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    private Query reprojectFilter(Query query) throws IOException {
        SimpleFeatureType nativeFeatureType = (SimpleFeatureType)this.source.getSchema();
        GeometryDescriptor geom = nativeFeatureType.getGeometryDescriptor();
        if (geom == null) {
            return query;
        }
        try {
            CoordinateReferenceSystem defaultCRS = null;
            CoordinateReferenceSystem targetCRS = null;
            CoordinateReferenceSystem nativeCRS = geom.getCoordinateReferenceSystem();
            if (this.srsHandling == ProjectionPolicy.FORCE_DECLARED) {
                defaultCRS = this.declaredCRS;
                targetCRS = this.declaredCRS;
                nativeFeatureType = FeatureTypes.transform((SimpleFeatureType)nativeFeatureType, (CoordinateReferenceSystem)this.declaredCRS);
            } else if (this.srsHandling == ProjectionPolicy.REPROJECT_TO_DECLARED) {
                defaultCRS = this.declaredCRS;
                targetCRS = nativeCRS;
            } else {
                defaultCRS = nativeCRS;
                targetCRS = nativeCRS;
            }
            DefaultCRSFilterVisitor defaultCRSVisitor = new DefaultCRSFilterVisitor(this.ff, defaultCRS);
            Filter defaultedFilter = (Filter)query.getFilter().accept((FilterVisitor)defaultCRSVisitor, null);
            ReprojectingFilterVisitor reprojectingVisitor = new ReprojectingFilterVisitor(this.ff, (FeatureType)nativeFeatureType);
            Filter reprojectedFilter = (Filter)defaultedFilter.accept((FilterVisitor)reprojectingVisitor, null);
            DefaultQuery reprojectedQuery = new DefaultQuery(query);
            reprojectedQuery.setFilter(reprojectedFilter);
            return reprojectedQuery;
        }
        catch (Exception e) {
            throw new DataSourceException("Had troubles handling filter reprojection...", (Throwable)e);
        }
    }

    protected FeatureCollection<SimpleFeatureType, SimpleFeature> applyProjectionPolicies(CoordinateReferenceSystem targetCRS, FeatureCollection<SimpleFeatureType, SimpleFeature> fc) throws IOException, SchemaException, TransformException, OperationNotFoundException, FactoryException {
        if (((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor() == null) {
            return fc;
        }
        CoordinateReferenceSystem nativeCRS = ((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
        if (nativeCRS == null) {
            if (this.declaredCRS != null) {
                fc = new ForceCoordinateSystemFeatureResults(fc, this.declaredCRS);
                nativeCRS = this.declaredCRS;
            }
        } else if (this.srsHandling == ProjectionPolicy.FORCE_DECLARED && !nativeCRS.equals(this.declaredCRS)) {
            fc = new ForceCoordinateSystemFeatureResults((FeatureCollection)fc, this.declaredCRS);
            nativeCRS = this.declaredCRS;
        } else if (this.srsHandling == ProjectionPolicy.REPROJECT_TO_DECLARED && targetCRS == null && !nativeCRS.equals(this.declaredCRS)) {
            fc = new ReprojectFeatureResults((FeatureCollection)fc, this.declaredCRS);
        }
        if (targetCRS != null) {
            if (nativeCRS == null) {
                fc = new ReprojectFeatureResults((FeatureCollection)fc, targetCRS);
            } else if (!CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)targetCRS)) {
                fc = new ReprojectFeatureResults((FeatureCollection)fc, targetCRS);
            }
        }
        return fc;
    }

    protected Query adaptQuery(Query query, SimpleFeatureType schema) throws IOException {
        Query newQuery = this.makeDefinitionQuery(query, schema);
        if (newQuery.getCoordinateSystemReproject() != null) {
            ((DefaultQuery)newQuery).setCoordinateSystemReproject(null);
        }
        if (newQuery.getCoordinateSystem() != null) {
            ((DefaultQuery)newQuery).setCoordinateSystem(null);
        }
        return newQuery;
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Filter filter) throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.schema.getTypeName(), filter));
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public ReferencedEnvelope getBounds() throws IOException {
        if (this.definitionQuery == Filter.INCLUDE) {
            return this.source.getBounds();
        }
        DefaultQuery query = new DefaultQuery(this.getSchema().getTypeName(), this.definitionQuery);
        return this.source.getBounds((Query)query);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        try {
            query = this.makeDefinitionQuery(query, this.schema);
        }
        catch (IOException ex) {
            return null;
        }
        return this.source.getBounds(query);
    }

    public int getCount(Query query) {
        try {
            query = this.makeDefinitionQuery(query, this.schema);
        }
        catch (IOException ex) {
            return -1;
        }
        try {
            return this.source.getCount(query);
        }
        catch (IOException e) {
            return 0;
        }
    }

    public Set getSupportedHints() {
        return this.source.getSupportedHints();
    }

    public ResourceInfo getInfo() {
        return this.source.getInfo();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.source.getQueryCapabilities();
    }
}

