/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.security.impl.AbstractAuthorizationTest;
import org.springframework.security.SpringSecurityException;

public class ReadSecuredCatalogDecoratorsTest
extends AbstractAuthorizationTest {
    public void testSecuredLayerInfoFeatures() {
        SecuredLayerInfo ro = new SecuredLayerInfo(this.statesLayer, WrapperPolicy.hide(null));
        ReadSecuredCatalogDecoratorsTest.assertFalse((boolean)(this.statesLayer.getResource() instanceof SecuredFeatureTypeInfo));
        ReadSecuredCatalogDecoratorsTest.assertTrue((boolean)(ro.getResource() instanceof SecuredFeatureTypeInfo));
        ReadSecuredCatalogDecoratorsTest.assertSame((Object)ro.policy, (Object)((SecuredFeatureTypeInfo)ro.getResource()).policy);
    }

    public void testSecuredLayerInfoCoverages() {
        SecuredLayerInfo ro = new SecuredLayerInfo(this.arcGridLayer, WrapperPolicy.hide(null));
        ReadSecuredCatalogDecoratorsTest.assertFalse((boolean)(this.arcGridLayer.getResource() instanceof SecuredCoverageInfo));
        ReadSecuredCatalogDecoratorsTest.assertTrue((boolean)(ro.getResource() instanceof SecuredCoverageInfo));
        ReadSecuredCatalogDecoratorsTest.assertSame((Object)ro.policy, (Object)((SecuredCoverageInfo)ro.getResource()).policy);
    }

    public void testSecuredFeatureTypeInfoHide() throws Exception {
        SecuredFeatureTypeInfo ro = new SecuredFeatureTypeInfo(this.states, WrapperPolicy.hide(null));
        SecuredFeatureSource fs = (SecuredFeatureSource)ro.getFeatureSource(null, null);
        ReadSecuredCatalogDecoratorsTest.assertEquals(SecuredFeatureSource.class, fs.getClass());
        ReadSecuredCatalogDecoratorsTest.assertTrue((boolean)fs.policy.isHide());
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        ReadSecuredCatalogDecoratorsTest.assertTrue((boolean)store.policy.isHide());
    }

    public void testSecuredFeatureTypeInfoMetadata() throws Exception {
        SecuredFeatureTypeInfo ro = new SecuredFeatureTypeInfo(this.states, WrapperPolicy.metadata(null));
        try {
            ro.getFeatureSource(null, null);
            ReadSecuredCatalogDecoratorsTest.fail((String)"This should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        ReadSecuredCatalogDecoratorsTest.assertTrue((boolean)store.policy.isMetadata());
    }

    public void testSecuredTypeInfoReadOnly() throws Exception {
        SecuredFeatureTypeInfo ro = new SecuredFeatureTypeInfo(this.states, WrapperPolicy.readOnlyChallenge(null));
        SecuredFeatureStore fs = (SecuredFeatureStore)ro.getFeatureSource(null, null);
        ReadSecuredCatalogDecoratorsTest.assertTrue((boolean)fs.policy.isReadOnlyChallenge());
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        ReadSecuredCatalogDecoratorsTest.assertTrue((boolean)store.policy.isReadOnlyChallenge());
    }

    public void testSecuredDataStoreInfoHide() throws Exception {
        SecuredDataStoreInfo ro = new SecuredDataStoreInfo(this.statesStore, WrapperPolicy.hide(null));
        ReadOnlyDataStore dataStore = (ReadOnlyDataStore)ro.getDataStore(null);
        ReadSecuredCatalogDecoratorsTest.assertTrue((boolean)dataStore.policy.isHide());
    }

    public void testSecuredDataStoreInfoMetadata() throws Exception {
        SecuredDataStoreInfo ro = new SecuredDataStoreInfo(this.statesStore, WrapperPolicy.metadata(null));
        try {
            ReadOnlyDataStore dataStore = (ReadOnlyDataStore)ro.getDataStore(null);
            ReadSecuredCatalogDecoratorsTest.fail((String)"This should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
    }
}

