/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.SecuredFeatureCollection;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.springframework.security.SpringSecurityException;

public class SecuredFeatureSourceTest
extends SecureObjectsTest {
    public void testReadOnlyFeatureSourceDataStore() throws Exception {
        DataStore ds = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.replay((Object[])new Object[]{ds});
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        FeatureCollection fc = (FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)ds);
        EasyMock.expect((Object)fs.getFeatures()).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fs.getFeatures((Filter)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fs.getFeatures((Query)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.replay((Object[])new Object[]{fs});
        SecuredFeatureSource ro = new SecuredFeatureSource(fs, WrapperPolicy.hide(null));
        SecuredFeatureSourceTest.assertTrue((boolean)(ro.getDataStore() instanceof ReadOnlyDataStore));
        SecuredFeatureCollection collection = (SecuredFeatureCollection)ro.getFeatures();
        SecuredFeatureSourceTest.assertTrue((boolean)ro.policy.isHide());
        SecuredFeatureSourceTest.assertTrue((boolean)(ro.getFeatures((Filter)Filter.INCLUDE) instanceof SecuredFeatureCollection));
        SecuredFeatureSourceTest.assertTrue((boolean)(ro.getFeatures(new Query()) instanceof SecuredFeatureCollection));
    }

    public void testReadOnlyFeatureStore() throws Exception {
        SimpleFeatureType schema = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
        EasyMock.expect((Object)schema.getName()).andReturn((Object)new NameImpl("testFT"));
        EasyMock.replay((Object[])new Object[]{schema});
        FeatureStore fs = (FeatureStore)EasyMock.createNiceMock(FeatureStore.class);
        EasyMock.expect((Object)fs.getSchema()).andReturn((Object)schema);
        EasyMock.replay((Object[])new Object[]{fs});
        SecuredFeatureStore ro = new SecuredFeatureStore(fs, WrapperPolicy.readOnlyChallenge(null));
        try {
            ro.addFeatures((FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class));
            SecuredFeatureSourceTest.fail((String)"This should have thrown a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
    }

    public void testReadOnlyFeatureSourceDataAccess() throws Exception {
        DataAccess da = (DataAccess)EasyMock.createNiceMock(DataAccess.class);
        EasyMock.replay((Object[])new Object[]{da});
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)da);
        EasyMock.replay((Object[])new Object[]{fs});
        SecuredFeatureSource ro = new SecuredFeatureSource(fs, WrapperPolicy.readOnlyChallenge(null));
        SecuredFeatureSourceTest.assertTrue((boolean)(ro.getDataStore() instanceof ReadOnlyDataAccess));
    }
}

