/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.geoserver.data.util.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.ui.context.Theme;
import org.springframework.web.context.WebApplicationContext;

public class GeoServerTestApplicationContext
extends ClassPathXmlApplicationContext
implements WebApplicationContext {
    ServletContext servletContext;
    boolean useLegacyGeoServerLoader = true;

    public GeoServerTestApplicationContext(String configLocation, ServletContext servletContext) throws BeansException {
        this(new String[]{configLocation}, servletContext);
    }

    public GeoServerTestApplicationContext(String[] configLocation, ServletContext servletContext) throws BeansException {
        super(configLocation, false);
        try {
            servletContext.setAttribute("javax.servlet.context.tempdir", (Object)IOUtils.createRandomDirectory((String)"./target", (String)"mock", (String)"tmp"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Theme getTheme(String themeName) {
        return null;
    }

    public void setUseLegacyGeoServerLoader(boolean useLegacyGeoServerLoader) {
        this.useLegacyGeoServerLoader = useLegacyGeoServerLoader;
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        BeanDefinition def;
        super.loadBeanDefinitions(reader);
        if (this.useLegacyGeoServerLoader) {
            def = reader.getBeanFactory().getBeanDefinition("geoServerLoader");
            def.setBeanClassName("org.geoserver.test.TestGeoServerLoaderProxy");
        }
        try {
            def = reader.getBeanFactory().getBeanDefinition("wcsLoader");
            def.getConstructorArgumentValues().clear();
            def.setBeanClassName("org.geoserver.wcs.WCSLoader");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }
}

