/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.ows.Layer;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class RemoteOWSTestSupport {
    public static final String TOPP_STATES = "topp:states";
    public static final String WFS_SERVER_URL = "http://demo.opengeo.org/geoserver/wfs?";
    public static final String WMS_SERVER_URL = "http://demo.opengeo.org/geoserver/wms?";
    static Boolean remoteWMSStatesAvailable;
    static Boolean remoteWFSStatesAvailable;

    public static boolean isRemoteWFSStatesAvailable(Logger logger) {
        if (remoteWFSStatesAvailable == null) {
            String value = System.getProperty("remoteOwsTests");
            if (value == null || !"TRUE".equalsIgnoreCase(value)) {
                logger.log(Level.WARNING, "Skipping remote WFS test because they were not enabled via -DremoteOwsTests=true");
                remoteWFSStatesAvailable = Boolean.FALSE;
            } else {
                try {
                    WFSDataStoreFactory factory = new WFSDataStoreFactory();
                    HashMap<String, Serializable> params = new HashMap<String, Serializable>(factory.getImplementationHints());
                    URL url = new URL("http://demo.opengeo.org/geoserver/wfs?service=WFS&request=GetCapabilities");
                    params.put(WFSDataStoreFactory.URL.key, url);
                    params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
                    params.put(WFSDataStoreFactory.TIMEOUT.key, Integer.valueOf(5000));
                    WFSDataStore remoteStore = factory.createDataStore(params);
                    SimpleFeatureSource fs = remoteStore.getFeatureSource(TOPP_STATES);
                    remoteWFSStatesAvailable = Boolean.TRUE;
                    Query dq = new Query(TOPP_STATES);
                    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                    dq.setFilter((Filter)ff.greater((Expression)ff.property("PERSONS"), (Expression)ff.literal(20000000)));
                    FeatureCollection fc = fs.getFeatures(dq);
                    if (fc.size() != 1) {
                        logger.log(Level.WARNING, "Remote database status invalid, there should be one and only one feature with more than 20M persons in topp:states");
                        remoteWFSStatesAvailable = Boolean.FALSE;
                    }
                    logger.log(Level.WARNING, "Remote WFS tests are enabled, remote server appears to be up");
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Skipping remote wms test, either demo  is down or the topp:states layer is not there", e);
                    remoteWFSStatesAvailable = Boolean.FALSE;
                }
            }
        }
        return remoteWFSStatesAvailable;
    }

    public static boolean isRemoteWMSStatesAvailable(Logger logger) {
        if (remoteWMSStatesAvailable == null) {
            String value = System.getProperty("remoteOwsTests");
            if (value == null || !"TRUE".equalsIgnoreCase(value)) {
                logger.log(Level.WARNING, "Skipping remote OWS test because they were not enabled via -DremoteOwsTests=true");
                remoteWMSStatesAvailable = Boolean.FALSE;
            } else {
                try {
                    remoteWMSStatesAvailable = Boolean.FALSE;
                    WebMapServer server = new WebMapServer(new URL("http://demo.opengeo.org/geoserver/wms?service=WMS&request=GetCapabilities"), 5000);
                    for (Layer l : server.getCapabilities().getLayerList()) {
                        if (!TOPP_STATES.equals(l.getName())) continue;
                        remoteWMSStatesAvailable = Boolean.TRUE;
                        break;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Skipping remote WMS test, either demo  is down or the topp:states layer is not there", e);
                    remoteWMSStatesAvailable = Boolean.FALSE;
                }
            }
        }
        return remoteWMSStatesAvailable;
    }
}

