/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.vividsolutions.jts.geom.Point;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geotools.data.Query;
import org.geotools.feature.NameImpl;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.Name;

public class CatalogBuilderTest
extends GeoServerTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup(new CatalogBuilderTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addWellKnownCoverageTypes();
    }

    public void testFeatureTypeNoSRS() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.BRIDGES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.BRIDGES));
        CatalogBuilderTest.assertNull((Object)fti.getSRS());
        CatalogBuilderTest.assertNull((Object)fti.getNativeCRS());
        CatalogBuilderTest.assertNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNull((Object)fti.getLatLonBoundingBox());
        cb.setupBounds((ResourceInfo)fti);
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNull((Object)fti.getNativeBoundingBox().getCoordinateReferenceSystem());
        CatalogBuilderTest.assertNull((Object)fti.getLatLonBoundingBox());
    }

    public void testFeatureType() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.LINES.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.LINES));
        CatalogBuilderTest.assertEquals((String)"EPSG:32615", (String)fti.getSRS());
        CatalogBuilderTest.assertEquals((Object)CRS.decode((String)"EPSG:32615", (boolean)true), (Object)fti.getCRS());
        CatalogBuilderTest.assertNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNull((Object)fti.getLatLonBoundingBox());
        cb.setupBounds((ResourceInfo)fti);
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeBoundingBox().getCoordinateReferenceSystem());
        CatalogBuilderTest.assertNotNull((Object)fti.getLatLonBoundingBox());
    }

    public void testGeometryless() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getDataStoreByName(MockData.GEOMETRYLESS.getPrefix()));
        FeatureTypeInfo fti = cb.buildFeatureType(this.toName(MockData.GEOMETRYLESS));
        LayerInfo layer = cb.buildLayer(fti);
        cb.setupBounds((ResourceInfo)fti);
        CatalogBuilderTest.assertNull((Object)fti.getCRS());
        CatalogBuilderTest.assertTrue((boolean)fti.getNativeBoundingBox().isEmpty());
        CatalogBuilderTest.assertNull((Object)fti.getLatLonBoundingBox());
        CatalogBuilderTest.assertNull((Object)layer.getDefaultStyle());
    }

    public void testCoverage() throws Exception {
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)cat.getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart()));
        CoverageInfo fti = cb.buildCoverage();
        CatalogBuilderTest.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)true), (Object)fti.getCRS());
        CatalogBuilderTest.assertEquals((String)"EPSG:4326", (String)fti.getSRS());
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeCRS());
        CatalogBuilderTest.assertNotNull((Object)fti.getNativeBoundingBox());
        CatalogBuilderTest.assertNotNull((Object)fti.getLatLonBoundingBox());
    }

    public void testEmptyBounds() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo fti = cat.getFeatureTypeByName(this.getLayerId(MockData.POINTS));
        CatalogBuilderTest.assertEquals(Point.class, (Object)fti.getFeatureType().getGeometryDescriptor().getType().getBinding());
        CatalogBuilderTest.assertEquals((int)1, (int)fti.getFeatureSource(null, null).getCount(Query.ALL));
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore(cat.getStoreByName(MockData.CGF_PREFIX, DataStoreInfo.class));
        FeatureTypeInfo built = cb.buildFeatureType(fti.getQualifiedName());
        cb.setupBounds((ResourceInfo)built);
        CatalogBuilderTest.assertTrue((built.getNativeBoundingBox().getWidth() > 0.0 ? 1 : 0) != 0);
        CatalogBuilderTest.assertTrue((built.getNativeBoundingBox().getHeight() > 0.0 ? 1 : 0) != 0);
    }

    public void testWMS() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable(LOGGER)) {
            LOGGER.warning("Remote OWS tests disabled, skipping catalog builder wms tests");
            return;
        }
        Catalog cat = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(cat);
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?service=WMS&request=GetCapabilities");
        cat.save((StoreInfo)wms);
        cb.setStore((StoreInfo)wms);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("topp:states");
        CatalogBuilderTest.assertEquals((String)"states", (String)wmsLayer.getName());
        CatalogBuilderTest.assertEquals((String)"topp:states", (String)wmsLayer.getNativeName());
        CatalogBuilderTest.assertEquals((String)"EPSG:4326", (String)wmsLayer.getSRS());
        CatalogBuilderTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)wmsLayer.getNativeCRS());
        CatalogBuilderTest.assertNotNull((Object)wmsLayer.getNativeBoundingBox());
        CatalogBuilderTest.assertNotNull((Object)wmsLayer.getLatLonBoundingBox());
        LayerInfo layer = cb.buildLayer(wmsLayer);
        CatalogBuilderTest.assertEquals((Object)LayerInfo.Type.WMS, (Object)layer.getType());
    }

    Name toName(QName qname) {
        return new NameImpl(qname.getNamespaceURI(), qname.getLocalPart());
    }
}

