/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.springframework.security.SpringSecurityException;

public class ReadOnlyDataAccessTest
extends SecureObjectsTest {
    private DataAccess da;
    private NameImpl name;

    protected void setUp() throws Exception {
        super.setUp();
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        EasyMock.replay((Object[])new Object[]{fs});
        FeatureType schema = (FeatureType)EasyMock.createNiceMock(FeatureType.class);
        EasyMock.replay((Object[])new Object[]{schema});
        this.da = (DataAccess)EasyMock.createNiceMock(DataAccess.class);
        this.name = new NameImpl("blah");
        EasyMock.expect((Object)this.da.getFeatureSource((Name)this.name)).andReturn((Object)fs);
        EasyMock.replay((Object[])new Object[]{this.da});
    }

    public void testDontChallenge() throws Exception {
        ReadOnlyDataAccess ro = new ReadOnlyDataAccess(this.da, WrapperPolicy.hide(null));
        SecuredFeatureSource fs = (SecuredFeatureSource)ro.getFeatureSource((Name)this.name);
        ReadOnlyDataAccessTest.assertTrue((boolean)fs.policy.isHide());
        try {
            ro.createSchema(null);
            ReadOnlyDataAccessTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            ReadOnlyDataAccessTest.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testChallenge() throws Exception {
        ReadOnlyDataAccess ro = new ReadOnlyDataAccess(this.da, WrapperPolicy.readOnlyChallenge(null));
        SecuredFeatureSource fs = (SecuredFeatureSource)ro.getFeatureSource((Name)this.name);
        ReadOnlyDataAccessTest.assertTrue((boolean)fs.policy.isReadOnlyChallenge());
        try {
            ro.createSchema(null);
            ReadOnlyDataAccessTest.fail((String)"Should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            ReadOnlyDataAccessTest.fail((String)"Should have failed with a security exception");
        }
        catch (SpringSecurityException springSecurityException) {
            // empty catch block
        }
    }
}

