/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import junit.framework.TestCase;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.SecureTreeNode;
import org.springframework.security.Authentication;
import org.springframework.security.providers.TestingAuthenticationToken;

public class SecureTreeNodeTest
extends TestCase {
    private TestingAuthenticationToken anonymous;

    protected void setUp() throws Exception {
        this.anonymous = new TestingAuthenticationToken((Object)"anonymous", null);
    }

    public void testEmptyRoot() {
        SecureTreeNode root = new SecureTreeNode();
        SecureTreeNodeTest.assertNull((Object)root.getChild("NotThere"));
        SecureTreeNodeTest.assertEquals((Object)SecureTreeNode.EVERYBODY, (Object)root.getAuthorizedRoles(AccessMode.READ));
        SecureTreeNodeTest.assertEquals((Object)SecureTreeNode.EVERYBODY, (Object)root.getAuthorizedRoles(AccessMode.WRITE));
        SecureTreeNode node = root.getDeepestNode(new String[]{"a", "b"});
        SecureTreeNodeTest.assertSame((Object)root, (Object)node);
        SecureTreeNodeTest.assertTrue((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.WRITE));
        SecureTreeNodeTest.assertTrue((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.READ));
        SecureTreeNodeTest.assertTrue((boolean)root.canAccess(null, AccessMode.WRITE));
        SecureTreeNodeTest.assertTrue((boolean)root.canAccess(null, AccessMode.READ));
    }
}

