/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.test.GeoServerTestSupport;
import org.vfny.geoserver.util.SLDValidator;

public class SLDValidatorTest
extends GeoServerTestSupport {
    protected void setUpInternal() throws Exception {
        GeoServerResourceLoader rl = this.getResourceLoader();
        this.copyToWebInf(rl, "gml/2.1.2.1/geometry.xsd");
        this.copyToWebInf(rl, "gml/2.1.2.1/feature.xsd");
        this.copyToWebInf(rl, "xlink/1.0.0/xlinks.xsd");
        this.copyToWebInf(rl, "filter/1.0.0/expr.xsd");
        this.copyToWebInf(rl, "filter/1.0.0/filter.xsd");
        this.copyToWebInf(rl, "sld/StyledLayerDescriptor.xsd");
    }

    void copyToWebInf(GeoServerResourceLoader rl, String file) throws IOException {
        File f = new File("../web/app/src/main/webapp/schemas/" + file);
        FileUtils.copyFile((File)f, (File)rl.createFile("WEB-INF/schemas/" + file));
    }

    public void testValid() throws Exception {
        SLDValidator validator = new SLDValidator();
        List errors = validator.validateSLD(((Object)((Object)this)).getClass().getResourceAsStream("valid.sld"), null);
        SLDValidatorTest.assertTrue((boolean)errors.isEmpty());
    }

    public void testInvalid() throws Exception {
        SLDValidator validator = new SLDValidator();
        List errors = validator.validateSLD(((Object)((Object)this)).getClass().getResourceAsStream("invalid.sld"), null);
        this.showErrors(errors);
        SLDValidatorTest.assertFalse((boolean)errors.isEmpty());
    }

    void showErrors(List errors) {
        for (Exception err : errors) {
            System.out.println(err.getMessage());
        }
    }
}

