/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.util.LegacyCatalogImporter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.util.LegacyConfigurationImporter;
import org.geoserver.platform.GeoServerResourceLoader;

public class LegacyGeoServerLoader
extends GeoServerLoader {
    public LegacyGeoServerLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected void loadCatalog(Catalog catalog) throws Exception {
        catalog.setResourceLoader(this.resourceLoader);
        File f = this.resourceLoader.find("catalog.xml");
        if (f != null) {
            LegacyCatalogImporter catalogImporter = new LegacyCatalogImporter();
            catalogImporter.setResourceLoader(this.resourceLoader);
            catalogImporter.setCatalog(catalog);
            catalogImporter.imprt(this.resourceLoader.getBaseDirectory());
        } else {
            LOGGER.warning("No catalog file found.");
        }
    }

    protected void loadGeoServer(GeoServer geoServer) throws Exception {
        File f = this.resourceLoader.find("services.xml");
        if (f != null) {
            LegacyConfigurationImporter importer = new LegacyConfigurationImporter();
            importer.setConfiguration(geoServer);
            importer.imprt(this.resourceLoader.getBaseDirectory());
        } else {
            LOGGER.warning("No configuration file found.");
        }
    }
}

