/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessMode;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.DataAccessRule;
import org.geoserver.security.PropertyFileWatcher;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class DataAccessRuleDAO {
    static final Logger LOGGER = Logging.getLogger(DataAccessRuleDAO.class);
    Catalog rawCatalog;
    TreeSet<DataAccessRule> rules;
    DataAccessManager.CatalogMode catalogMode = DataAccessManager.CatalogMode.HIDE;
    PropertyFileWatcher watcher;
    long lastModified;
    File securityDir;

    public static DataAccessRuleDAO get() {
        return (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class);
    }

    public DataAccessRuleDAO(Catalog rawCatalog) throws ConfigurationException {
        this.rawCatalog = rawCatalog;
        this.securityDir = GeoserverDataDirectory.findCreateConfigDir("security");
    }

    DataAccessRuleDAO(Catalog rawCatalog, File securityDir) throws ConfigurationException {
        this.rawCatalog = rawCatalog;
        this.securityDir = securityDir;
    }

    public List<DataAccessRule> getRules() {
        this.checkPropertyFile(false);
        return new ArrayList<DataAccessRule>(this.rules);
    }

    public boolean addRule(DataAccessRule rule) {
        this.lastModified = System.currentTimeMillis();
        return this.rules.add(rule);
    }

    public void reload() {
        this.checkPropertyFile(true);
    }

    public void clear() {
        this.rules.clear();
        this.lastModified = System.currentTimeMillis();
    }

    public boolean removeRule(DataAccessRule rule) {
        this.lastModified = System.currentTimeMillis();
        return this.rules.remove(rule);
    }

    public DataAccessManager.CatalogMode getMode() {
        this.checkPropertyFile(false);
        return this.catalogMode;
    }

    public void storeRules() throws IOException {
        FileOutputStream os = null;
        try {
            Properties p = this.toProperties();
            File propFile = new File(this.securityDir, "layers.properties");
            os = new FileOutputStream(propFile);
            p.store(os, null);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)new IOException("Could not write updated data access rules to file system").initCause(e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    void checkPropertyFile(boolean force) {
        try {
            if (this.rules == null) {
                if (this.securityDir == null || !this.securityDir.exists()) {
                    this.rules = new TreeSet();
                } else {
                    File layers = new File(this.securityDir, "layers.properties");
                    if (!layers.exists()) {
                        this.rules = new TreeSet();
                    } else {
                        this.watcher = new PropertyFileWatcher(layers);
                        this.loadRules(this.watcher.getProperties());
                    }
                }
                this.lastModified = System.currentTimeMillis();
            } else if (this.watcher != null && (this.watcher.isStale() || force)) {
                this.loadRules(this.watcher.getProperties());
                this.lastModified = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to reload data access rules from layers.properties, keeping old rules", e);
        }
    }

    void loadRules(Properties props) {
        TreeSet<DataAccessRule> result = new TreeSet<DataAccessRule>();
        this.catalogMode = DataAccessManager.CatalogMode.HIDE;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String ruleKey = (String)entry.getKey();
            String ruleValue = (String)entry.getValue();
            if ("mode".equalsIgnoreCase(ruleKey)) {
                try {
                    this.catalogMode = DataAccessManager.CatalogMode.valueOf(ruleValue.toUpperCase());
                }
                catch (Exception e) {
                    LOGGER.warning("Invalid security mode " + ruleValue + " acceptable values are " + Arrays.asList(DataAccessManager.CatalogMode.values()));
                }
                continue;
            }
            DataAccessRule rule = this.parseDataAccessRule(ruleKey, ruleValue);
            if (rule == null) continue;
            if (result.contains(rule)) {
                LOGGER.warning("Rule " + ruleKey + "." + ruleValue + " overwrites another rule on the same path");
            }
            result.add(rule);
        }
        if (result.size() == 0) {
            result.add(new DataAccessRule(DataAccessRule.READ_ALL));
            result.add(new DataAccessRule(DataAccessRule.WRITE_ALL));
        }
        this.rules = result;
    }

    DataAccessRule parseDataAccessRule(String ruleKey, String ruleValue) {
        AccessMode mode;
        String rule = ruleKey + "=" + ruleValue;
        String[] elements = DataAccessRuleDAO.parseElements(ruleKey);
        if (elements.length != 3) {
            LOGGER.warning("Invalid rule " + rule + ", the expected format is workspace.layer.mode=role1,role2,...");
            return null;
        }
        String workspace = elements[0];
        String layerName = elements[1];
        String modeAlias = elements[2];
        Set<String> roles = this.parseRoles(ruleValue);
        if (elements.length != 3) {
            LOGGER.warning("Invalid rule '" + rule + "', the standard form is [namespace].[layer].[mode]=[role]+ " + "Rule has been ignored");
            return null;
        }
        if (!"*".equals(workspace) && this.rawCatalog.getWorkspaceByName(workspace) == null) {
            LOGGER.warning("Namespace/Workspace " + workspace + " is unknown in rule " + rule);
        }
        if (!"*".equals(layerName) && this.rawCatalog.getLayerByName(layerName) == null) {
            LOGGER.warning("Layer " + workspace + " is unknown in rule + " + rule);
        }
        if ((mode = AccessMode.getByAlias(modeAlias)) == null) {
            LOGGER.warning("Unknown access mode " + modeAlias + " in " + ruleKey + ", skipping rule " + rule);
            return null;
        }
        if ("*".equals(workspace) && !"*".equals(layerName)) {
            LOGGER.warning("Invalid rule " + rule + ", when namespace " + "is * then also layer must be *. Skipping rule " + rule);
            return null;
        }
        return new DataAccessRule(workspace, layerName, mode, roles);
    }

    Properties toProperties() {
        Properties props = new Properties();
        props.put("mode", this.catalogMode.toString());
        for (DataAccessRule rule : this.rules) {
            props.put(rule.getKey(), rule.getValue());
        }
        return props;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    Set<String> parseRoles(String roleCsv) {
        String[] rolesArray = roleCsv.split("[\\s,]+");
        HashSet<String> roles = new HashSet<String>(rolesArray.length);
        roles.addAll(Arrays.asList(rolesArray));
        for (String role : roles) {
            if (!"*".equals(role)) continue;
            return Collections.singleton("*");
        }
        return roles;
    }

    static String[] parseElements(String path) {
        String[] rawParse = path.trim().split("\\s*\\.\\s*");
        ArrayList<String> result = new ArrayList<String>();
        String prefix = null;
        for (String raw : rawParse) {
            if (prefix != null) {
                raw = prefix + "." + raw;
            }
            if (raw.endsWith("\\")) {
                prefix = raw.substring(0, raw.length() - 1);
                continue;
            }
            result.add(raw);
            prefix = null;
        }
        return result.toArray(new String[result.size()]);
    }

    public void setCatalogMode(DataAccessManager.CatalogMode catalogMode) {
        this.catalogMode = catalogMode;
    }

    public static DataAccessManager.CatalogMode getByAlias(String alias) {
        for (DataAccessManager.CatalogMode mode : DataAccessManager.CatalogMode.values()) {
            if (!mode.name().equals(alias)) continue;
            return mode;
        }
        return null;
    }
}

