/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSource;
import org.acegisecurity.util.StringSplitUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geoserver.security.RESTfulPathBasedFilterInvocationDefinitionMap;
import org.springframework.util.StringUtils;

public class RESTfulDefinitionSource
implements FilterInvocationDefinitionSource {
    private static Log log = LogFactory.getLog(RESTfulDefinitionSource.class);
    private static final String[] validMethodNames = new String[]{"GET", "PUT", "DELETE", "POST"};
    private RESTfulPathBasedFilterInvocationDefinitionMap delegate = new RESTfulPathBasedFilterInvocationDefinitionMap();

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be a FilterInvocation");
        }
        String url = ((FilterInvocation)object).getRequestUrl();
        String method = ((FilterInvocation)object).getHttpRequest().getMethod();
        return this.delegate.lookupAttributes(url, method);
    }

    public ConfigAttributeDefinition lookupAttributes(String url) {
        throw new IllegalArgumentException("lookupAttributes(String url) is INVALID for RESTfulDefinitionSource");
    }

    public ConfigAttributeDefinition lookupAttributes(String url, String method) {
        return this.delegate.lookupAttributes(url, method);
    }

    public Iterator getConfigAttributeDefinitions() {
        return this.delegate.getConfigAttributeDefinitions();
    }

    public boolean supports(Class clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public RESTfulDefinitionSource(String pathToRoleList) throws IllegalArgumentException {
        this.processPathList(pathToRoleList);
    }

    private void processPathList(String pathToRoleList) throws IllegalArgumentException {
        this.delegate.setConvertUrlToLowercaseBeforeComparison(true);
        BufferedReader br = new BufferedReader(new StringReader(pathToRoleList));
        int counter = 0;
        ArrayList<RESTfulDefinitionSourceMapping> mappings = new ArrayList<RESTfulDefinitionSourceMapping>();
        while (true) {
            int ii;
            String line;
            ++counter;
            try {
                line = br.readLine();
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe.getMessage());
            }
            if (line == null) break;
            line = line.trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Line " + counter + ": " + line));
            }
            if (line.startsWith("//") || line.lastIndexOf(61) == -1) continue;
            if (line.lastIndexOf("==") != -1) {
                throw new IllegalArgumentException("Only single equals should be used in line " + line);
            }
            String name = StringSplitUtils.substringBeforeLast((String)line, (String)"=");
            String value = StringSplitUtils.substringAfterLast((String)line, (String)"=");
            if (!StringUtils.hasText((String)name) || !StringUtils.hasText((String)value)) {
                throw new IllegalArgumentException("Failed to parse a valid name/value pair from " + line);
            }
            String antPath = name;
            String methods = null;
            int firstColonIndex = name.indexOf(":");
            if (log.isDebugEnabled()) {
                log.debug((Object)("~~~~~~~~~~ name= " + name + " firstColonIndex= " + firstColonIndex));
            }
            if (firstColonIndex != -1) {
                antPath = name.substring(0, firstColonIndex);
                methods = name.substring(firstColonIndex + 1, name.length());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("~~~~~~~~~~ name= " + name + " antPath= " + antPath + " methods= " + methods));
            }
            String[] methodList = null;
            if (methods != null) {
                methodList = methods.split(",");
                for (ii = 0; ii < methodList.length; ++ii) {
                    boolean matched = false;
                    for (int jj = 0; jj < validMethodNames.length; ++jj) {
                        if (!methodList[ii].equals(validMethodNames[jj])) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    throw new IllegalArgumentException("The HTTP Method Name (" + methodList[ii] + " does NOT equal a valid name (GET,PUT,POST,DELETE)");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("methodList = " + methodList));
                if (methodList != null) {
                    for (ii = 0; ii < methodList.length; ++ii) {
                        log.debug((Object)("method[" + ii + "]: " + methodList[ii]));
                    }
                }
            }
            for (int i = 0; i < antPath.length(); ++i) {
                String character = antPath.substring(i, i + 1);
                if (character.toLowerCase().equals(character)) continue;
                throw new IllegalArgumentException("You are using Ant Paths, yet you have specified an uppercase character in line: " + line + " (character '" + character + "')");
            }
            RESTfulDefinitionSourceMapping mapping = new RESTfulDefinitionSourceMapping();
            mapping.setUrl(antPath);
            mapping.setHttpMethods(methodList);
            String[] tokens = StringUtils.commaDelimitedListToStringArray((String)value);
            for (int i = 0; i < tokens.length; ++i) {
                mapping.addConfigAttribute(tokens[i].trim());
            }
            mappings.add(mapping);
        }
        this.setMappings(mappings);
    }

    public void setMappings(List mappings) {
        for (RESTfulDefinitionSourceMapping mapping : mappings) {
            ConfigAttributeDefinition configDefinition = new ConfigAttributeDefinition();
            for (String s : mapping.getConfigAttributes()) {
                configDefinition.addConfigAttribute((ConfigAttribute)new SecurityConfig(s));
            }
            this.delegate.addSecureUrl(mapping.getUrl(), mapping.getHttpMethods(), configDefinition);
        }
    }

    public static class RESTfulDefinitionSourceMapping {
        private String url = null;
        private List configAttributes = new ArrayList();
        private String[] httpMethods = null;

        public void setHttpMethods(String[] httpMethods) {
            this.httpMethods = httpMethods;
        }

        public String[] getHttpMethods() {
            return this.httpMethods;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setConfigAttributes(List roles) {
            this.configAttributes = roles;
        }

        public List getConfigAttributes() {
            return this.configAttributes;
        }

        public void addConfigAttribute(String configAttribute) {
            this.configAttributes.add(configAttribute);
        }
    }
}

