/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Request;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;

public class LegacyServiceExceptionHandler
extends ServiceExceptionHandler {
    protected String version = "1.2.0";
    protected String dtdLocation = null;
    protected String schemaLocation = null;
    protected String contentType = "text/xml";
    protected GeoServer geoServer;

    public LegacyServiceExceptionHandler(List services, GeoServer geoServer) {
        super(services);
        this.geoServer = geoServer;
    }

    public LegacyServiceExceptionHandler(Service service, GeoServer geoServer) {
        super(service);
        this.geoServer = geoServer;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDTDLocation(String dtd) {
        this.dtdLocation = dtd;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void handleServiceException(ServiceException exception, Request request) {
        String tab = "   ";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"");
        sb.append(" encoding=\"UTF-8\"");
        if (this.dtdLocation != null) {
            sb.append(" standalone=\"no\"");
        }
        sb.append("?>");
        if (this.dtdLocation != null) {
            String fullDtdLocation = ResponseUtils.buildSchemaURL((String)ResponseUtils.baseURL((HttpServletRequest)request.getHttpRequest()), (String)this.dtdLocation);
            sb.append("<!DOCTYPE ServiceExceptionReport SYSTEM \"" + fullDtdLocation + "\"> ");
        }
        sb.append("<ServiceExceptionReport version=\"" + this.version + "\" ");
        if (this.schemaLocation != null && this.dtdLocation == null) {
            String fullSchemaLocation = ResponseUtils.buildSchemaURL((String)ResponseUtils.baseURL((HttpServletRequest)request.getHttpRequest()), (String)this.schemaLocation);
            sb.append("xmlns=\"http://www.opengis.net/ogc\" ");
            sb.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            sb.append("xsi:schemaLocation=\"http://www.opengis.net/ogc " + fullSchemaLocation + "\"");
        }
        sb.append(">");
        sb.append(tab + "<ServiceException");
        if (exception.getCode() != null && !exception.getCode().equals("")) {
            sb.append(" code=\"" + exception.getCode() + "\"");
        }
        if (exception.getLocator() != null && !exception.getLocator().equals("")) {
            sb.append(" locator=\"" + exception.getLocator() + "\"");
        }
        sb.append(">");
        if (exception.getMessage() != null) {
            sb.append("\n" + tab + tab);
            OwsUtils.dumpExceptionMessages((ServiceException)exception, (StringBuffer)sb, (boolean)true);
            if (this.geoServer.getGlobal().isVerboseExceptions()) {
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(stackTrace));
                sb.append("\nDetails:\n");
                sb.append(ResponseUtils.encodeXML((String)new String(stackTrace.toByteArray())));
            }
        }
        sb.append("\n</ServiceException>");
        sb.append("</ServiceExceptionReport>");
        HttpServletResponse response = request.getHttpResponse();
        response.setContentType(this.contentType);
        response.setCharacterEncoding("UTF-8");
        try {
            response.getOutputStream().write(sb.toString().getBytes());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", e);
        }
    }
}

