/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassProperties {
    private static final List<Method> EMPTY = new ArrayList<Method>(0);
    List<Method> methods;
    List<Method> getters;
    List<Method> setters;

    public ClassProperties(Class clazz) {
        this.methods = Arrays.asList(clazz.getMethods());
        this.getters = new ArrayList<Method>();
        this.setters = new ArrayList<Method>();
        for (Method method : this.methods) {
            String name = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if ((name.startsWith("get") || name.startsWith("is")) && params.length == 0) {
                this.getters.add(method);
                continue;
            }
            if (!name.startsWith("set") || params.length != 1) continue;
            this.setters.add(method);
        }
        if (this.methods.size() == 0) {
            this.methods = EMPTY;
        }
        if (this.getters.size() == 0) {
            this.getters = EMPTY;
        }
        if (this.setters.size() == 0) {
            this.setters = EMPTY;
        }
    }

    public List<String> properties() {
        ArrayList<String> properties = new ArrayList<String>();
        for (Method g : this.getters) {
            properties.add(this.gp(g));
        }
        return properties;
    }

    public Method setter(String property, Class type) {
        for (Method setter : this.setters) {
            if (!setter.getName().substring(3).equalsIgnoreCase(property)) continue;
            if (type == null) {
                return setter;
            }
            Class<?> target = setter.getParameterTypes()[0];
            if (!target.isAssignableFrom(type) && (!target.isPrimitive() || type != ClassProperties.wrapper(target)) && (!type.isPrimitive() || target != ClassProperties.wrapper(type))) continue;
            return setter;
        }
        String lax = ClassProperties.lax(property);
        if (!lax.equals(property)) {
            return this.setter(lax, type);
        }
        return null;
    }

    public Method getter(String property, Class type) {
        for (Method getter : this.getters) {
            if (!this.gp(getter).equalsIgnoreCase(property)) continue;
            if (type == null) {
                return getter;
            }
            Class<?> target = getter.getReturnType();
            if (!type.isAssignableFrom(target) && (!target.isPrimitive() || type != ClassProperties.wrapper(target)) && (!type.isPrimitive() || target != ClassProperties.wrapper(type))) continue;
            return getter;
        }
        String lax = ClassProperties.lax(property);
        if (!lax.equals(property)) {
            return this.getter(lax, type);
        }
        return null;
    }

    static String lax(String property) {
        return property.replaceAll("_", "");
    }

    static Class wrapper(Class primitive) {
        if (Boolean.TYPE == primitive) {
            return Boolean.class;
        }
        if (Character.TYPE == primitive) {
            return Character.class;
        }
        if (Byte.TYPE == primitive) {
            return Byte.class;
        }
        if (Short.TYPE == primitive) {
            return Short.class;
        }
        if (Integer.TYPE == primitive) {
            return Integer.class;
        }
        if (Long.TYPE == primitive) {
            return Long.class;
        }
        if (Float.TYPE == primitive) {
            return Float.class;
        }
        if (Double.TYPE == primitive) {
            return Double.class;
        }
        return null;
    }

    public Method method(String name) {
        for (Method method : this.methods) {
            if (!method.getName().equalsIgnoreCase(name)) continue;
            return method;
        }
        return null;
    }

    String gp(Method getter) {
        return getter.getName().substring(getter.getName().startsWith("get") ? 3 : 2);
    }
}

