/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.AscCoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.DebugCoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.GTopo30CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.GeoTIFFCoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.IMGCoverageResponseDelegate;

public class CoverageResponseDelegateFactory {
    private static final List<CoverageResponseDelegate> encoders = new ArrayList<CoverageResponseDelegate>();

    static {
        encoders.add(new AscCoverageResponseDelegate());
        encoders.add(new IMGCoverageResponseDelegate());
        encoders.add(new GTopo30CoverageResponseDelegate());
        encoders.add(new GeoTIFFCoverageResponseDelegate());
        encoders.add(new DebugCoverageResponseDelegate());
    }

    private CoverageResponseDelegateFactory() {
    }

    public static CoverageResponseDelegate encoderFor(String outputFormat) {
        CoverageResponseDelegate encoder2 = null;
        for (CoverageResponseDelegate encoder2 : encoders) {
            if (!encoder2.canProduce(outputFormat)) continue;
            try {
                if (encoder2 == null) continue;
                return (CoverageResponseDelegate)encoder2.getClass().newInstance();
            }
            catch (IllegalAccessException ex) {
                NoSuchElementException e = new NoSuchElementException(new StringBuffer("Can't create the encoder ").append(encoder2.getClass().getName()).toString());
                e.initCause(ex);
                throw e;
            }
            catch (InstantiationException ex) {
                NoSuchElementException e = new NoSuchElementException(new StringBuffer("Can't create the encoder ").append(encoder2.getClass().getName()).toString());
                e.initCause(ex);
                throw e;
            }
        }
        return null;
    }
}

