/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.data.test.MockData;
import org.geoserver.wcs.test.WCSTestSupport;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetCapabilitiesTest
extends WCSTestSupport {
    public void testGetBasic() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
    }

    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        CoverageStoreInfo cvInfo = this.getCatalog().getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart());
        cvInfo.setURL("file:///I/AM/NOT/THERE");
        this.getCatalog().save((StoreInfo)cvInfo);
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        int count = this.getCatalog().getCoverages().size();
        GetCapabilitiesTest.assertEquals((int)(count - 1), (int)dom.getElementsByTagName("wcs:CoverageOfferingBrief").getLength());
    }

    public void testNoServiceContactInfo() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
    }

    public void testPostBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
    }

    public void testUpdateSequenceInferiorGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&updateSequence=-1");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        Node root = dom.getFirstChild();
        GetCapabilitiesTest.assertEquals((String)"wcs:WCS_Capabilities", (String)root.getNodeName());
        GetCapabilitiesTest.assertTrue((root.getChildNodes().getLength() > 0 ? 1 : 0) != 0);
    }

    public void testUpdateSequenceInferiorPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"-1\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        Node root = dom.getFirstChild();
        GetCapabilitiesTest.assertEquals((String)"wcs:WCS_Capabilities", (String)root.getNodeName());
        GetCapabilitiesTest.assertTrue((root.getChildNodes().getLength() > 0 ? 1 : 0) != 0);
    }

    public void testUpdateSequenceEqualsGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&updateSequence=0");
        Node root = dom.getFirstChild();
        GetCapabilitiesTest.assertEquals((String)"ServiceExceptionReport", (String)root.getNodeName());
        GetCapabilitiesTest.assertEquals((String)"CurrentUpdateSequence", (String)root.getFirstChild().getNextSibling().getAttributes().getNamedItem("code").getNodeValue());
    }

    public void testUpdateSequenceEqualsPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"0\"/>";
        Document dom = this.postAsDOM("wcs", request);
        Node root = dom.getFirstChild();
        GetCapabilitiesTest.assertEquals((String)"ServiceExceptionReport", (String)root.getNodeName());
        GetCapabilitiesTest.assertEquals((String)"CurrentUpdateSequence", (String)root.getFirstChild().getNextSibling().getAttributes().getNamedItem("code").getNodeValue());
    }

    public void testUpdateSequenceSuperiorGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&updateSequence=1");
        this.checkOws11Exception(dom);
    }

    public void testUpdateSequenceSuperiorPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"1\" version=\"1.0.0\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkOws11Exception(dom);
    }

    public void testSectionsBogus() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&section=Bogus");
        this.checkOws11Exception(dom);
        XMLAssert.assertXpathEvaluatesTo((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)"/ServiceExceptionReport/ServiceException/@code", (Document)dom);
    }

    public void testSectionsAll() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&section=/");
        this.checkValidationErrors(dom, WCS10_GETCAPABILITIES_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Service)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Capability)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ContentMetadata)", (Document)dom);
    }

    public void testOneSection() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0&section=/WCS_Capabilities/Service");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Service)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wcs:Capability)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wcs:ContentMetadata)", (Document)dom);
    }

    public void testWorkspaceQualified() throws Exception {
        int expected = this.getCatalog().getCoverageStores().size();
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        GetCapabilitiesTest.assertEquals((int)expected, (int)xpath.getMatchingNodes("//wcs:CoverageOfferingBrief", dom).getLength());
        expected = this.getCatalog().getCoverageStoresByWorkspace(MockData.CDF_PREFIX).size();
        dom = this.getAsDOM("cdf/wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        GetCapabilitiesTest.assertEquals((int)expected, (int)xpath.getMatchingNodes("//wcs:CoverageOfferingBrief", dom).getLength());
    }

    public void testLayerQualified() throws Exception {
        int expected = this.getCatalog().getCoverageStores().size();
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        GetCapabilitiesTest.assertEquals((int)expected, (int)xpath.getMatchingNodes("//wcs:CoverageOfferingBrief", dom).getLength());
        dom = this.getAsDOM("wcs/World/wcs?request=GetCapabilities&service=WCS&version=1.0.0");
        GetCapabilitiesTest.assertEquals((int)1, (int)xpath.getMatchingNodes("//wcs:CoverageOfferingBrief", dom).getLength());
    }
}

