/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import net.opengis.wcs10.GetCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wcs.kvp.Wcs10GetCoverageRequestReader;
import org.geoserver.wcs.test.WCSTestSupport;
import org.vfny.geoserver.wcs.WcsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCoverageReaderTest
extends WCSTestSupport {
    static Wcs10GetCoverageRequestReader reader;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetCoverageReaderTest());
    }

    @Override
    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        Catalog catalog = (Catalog)applicationContext.getBean("catalog");
        reader = new Wcs10GetCoverageRequestReader(catalog);
    }

    public void testMissingParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"Hey, format is missing, this should have failed");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)"MissingParameterValue", (String)e.getCode());
        }
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("SourceCoverage", layerId);
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"Hey, format is missing, this should have failed");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)"MissingParameterValue", (String)e.getCode());
        }
        raw.put("format", "image/tiff");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"Hey, boundingBox is missing, this should have failed");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)"MissingParameterValue", (String)e.getCode());
        }
        raw.put("version", "1.0.0");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("crs", "EPSG:4326");
        raw.put("width", "150");
        raw.put("height", "150");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        }
        catch (WcsException e) {
            GetCoverageReaderTest.fail((String)"This time all mandatory params where provided?");
            GetCoverageReaderTest.assertEquals((String)"MissingParameterValue", (String)e.getCode());
        }
    }

    private Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.0.0");
        raw.put("request", "GetCoverage");
        return raw;
    }

    public void testUnknownCoverageParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = "fairyTales:rumpelstilskin";
        raw.put("sourcecoverage", "fairyTales:rumpelstilskin");
        raw.put("format", "SuperCoolFormat");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("crs", "EPSG:4326");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"That coverage is not registered???");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)e.getCode());
            GetCoverageReaderTest.assertEquals((String)"sourcecoverage", (String)e.getLocator());
        }
    }

    public void testBasic() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("SourceCoverage", layerId);
        raw.put("version", "1.0.0");
        raw.put("format", "image/tiff");
        raw.put("BBOX", "-45,146,-42,147");
        raw.put("CRS", "EPSG:4326");
        raw.put("width", "150");
        raw.put("height", "150");
        GetCoverageType getCoverage = (GetCoverageType)reader.read(reader.createRequest(), this.parseKvp(raw), raw);
        GetCoverageReaderTest.assertEquals((String)layerId, (String)getCoverage.getSourceCoverage());
        GetCoverageReaderTest.assertEquals((String)"image/tiff", (String)getCoverage.getOutput().getFormat().getValue());
        GetCoverageReaderTest.assertEquals((String)"EPSG:4326", (String)getCoverage.getOutput().getCrs().getValue());
    }

    public void testUnsupportedCRS() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("SourceCoverage", layerId);
        raw.put("version", "1.0.0");
        raw.put("format", "image/tiff");
        raw.put("CRS", "urn:ogc:def:crs:EPSG:6.6:-1000");
        raw.put("width", "150");
        raw.put("height", "150");
        try {
            reader.read(reader.createRequest(), this.parseKvp(raw), raw);
            GetCoverageReaderTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageReaderTest.assertEquals((String)"crs", (String)e.getLocator());
            GetCoverageReaderTest.assertEquals((String)"InvalidParameterValue", (String)e.getCode());
        }
    }
}

