/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.util.Map;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wcs.AbstractGetCoverageTest;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;

public class GetCoverageTest
extends AbstractGetCoverageTest {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetCoverageTest());
    }

    protected String getLogConfiguration() {
        return "/DEFAULT_LOGGING.properties";
    }

    public void testKvpBasic() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("store", "false");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GetCoverageTest.assertEquals((int)1, (int)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        GetCoverageTest.assertEquals((Object)CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326"), (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
    }

    public void testAntimeridianWorld() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.WORLD);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "175,10,-175,20,urn:ogc:def:crs:OGC:1.3:CRS84");
        raw.put("store", "false");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GetCoverageTest.assertEquals((int)1, (int)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        GetCoverageTest.assertEquals((Object)CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326"), (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
    }

    public void testAntimeridianTaz() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("store", "false");
        raw.put("BoundingBox", "145,-80,-175,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "147,-80,-175,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "147.2,-80,147,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "175,-80,147,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
        raw.put("BoundingBox", "175,-80,150,0,urn:ogc:def:crs:OGC:1.3:CRS84");
        this.executeGetCoverageKvp(raw);
    }

    public void testWrongFormatParams() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "SuperCoolFormat");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        try {
            this.executeGetCoverageKvp(raw);
            GetCoverageTest.fail((String)"When did we learn to encode SuperCoolFormat?");
        }
        catch (WcsException e) {
            GetCoverageTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)e.getCode());
            GetCoverageTest.assertEquals((String)"format", (String)e.getLocator());
        }
    }

    public void testWrongGridOrigin() throws Exception {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/geotiff");
        raw.put("BoundingBox", "-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("GridOrigin", "12,13,14");
        try {
            this.executeGetCoverageKvp(raw);
            GetCoverageTest.fail((String)"We should have had a WcsException here?");
        }
        catch (WcsException e) {
            GetCoverageTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.name(), (String)e.getCode());
            GetCoverageTest.assertEquals((String)"GridOrigin", (String)e.getLocator());
        }
    }

    public void testWorkspaceQualified() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
        MockHttpServletResponse r = this.getAsServletResponse("wcs?identifier=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
        GetCoverageTest.assertTrue((boolean)r.getContentType().startsWith("multipart/related"));
        Document dom = this.getAsDOM("cdf/wcs?identifier=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
        GetCoverageTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
    }

    public void testLayerQualified() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
        MockHttpServletResponse r = this.getAsServletResponse("wcs/BlueMarble/wcs?identifier=BlueMarble" + queryString);
        GetCoverageTest.assertTrue((boolean)r.getContentType().startsWith("multipart/related"));
        Document dom = this.getAsDOM("wcs/DEM/wcs?identifier=BlueMarble" + queryString);
        GetCoverageTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
    }

    public void testInputLimits() throws Exception {
        try {
            this.setInputLimit(1);
            String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
            Document dom = this.getAsDOM("wcs/BlueMarble/wcs?identifier=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            GetCoverageTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
            String error = xpath.evaluate("/ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()", dom);
            GetCoverageTest.assertTrue((boolean)error.matches(".*read too much data.*"));
        }
        finally {
            this.setInputLimit(0);
        }
    }

    public void testOutputLimits() throws Exception {
        try {
            this.setOutputLimit(1);
            String queryString = "&request=getcoverage&service=wcs&version=1.1.1&&format=image/geotiff&BoundingBox=-45,146,-42,147,urn:ogc:def:crs:EPSG:6.6:4326";
            Document dom = this.getAsDOM("wcs/BlueMarble/wcs?identifier=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            GetCoverageTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
            String error = xpath.evaluate("/ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()", dom);
            System.out.println(error);
            GetCoverageTest.assertTrue((boolean)error.matches(".*generate too much data.*"));
        }
        finally {
            this.setOutputLimit(0);
        }
    }
}

