/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import javax.xml.namespace.QName;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.web.demo.PreviewLayerProvider;

public class PreviewLayerProviderTest
extends GeoServerWicketTestSupport {
    public void testNonAdvertisedLayer() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            PreviewLayer pl = this.getPreviewLayer(provider, MockData.BUILDINGS);
            PreviewLayerProviderTest.assertNotNull((Object)pl);
            layer.setAdvertised(false);
            this.getCatalog().save(layer);
            pl = this.getPreviewLayer(provider, MockData.BUILDINGS);
            PreviewLayerProviderTest.assertNull((Object)pl);
        }
        finally {
            layer.setAdvertised(true);
            this.getCatalog().save(layer);
        }
    }

    private PreviewLayer getPreviewLayer(PreviewLayerProvider provider, QName layer) {
        String layerId = this.getLayerId(layer);
        for (PreviewLayer pl : provider.getItems()) {
            if (!pl.getName().equals(layerId)) continue;
            return pl;
        }
        return null;
    }
}

